/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.app.active.ActiveNotificationHandler;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.external.feed.watch.StatsSubscriber;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;

public class ActiveStatsApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = Logger.getLogger(ActiveStatsApiServlet.class.getName());
    private static final int DEFAULT_EXPIRE_TIME = 2000;
    private final ActiveNotificationHandler activeNotificationHandler;

    public ActiveStatsApiServlet(ConcurrentMap<String, Object> ctx, String[] paths, ICcApplicationContext appCtx) {
        super(ctx, paths);
        this.activeNotificationHandler = (ActiveNotificationHandler)appCtx.getActiveNotificationHandler();
    }

    private JsonNode constructNode(ObjectMapper om, IActiveEntityEventsListener eventListener, long currentTime, long ttl) throws Exception {
        long statsTimeStamp = eventListener.getStatsTimeStamp();
        if (currentTime - statsTimeStamp > ttl) {
            StatsSubscriber subscriber = new StatsSubscriber(eventListener);
            eventListener.refreshStats(5000L);
            subscriber.sync();
        }
        return om.readTree(eventListener.getStats());
    }

    protected void get(IServletRequest request, IServletResponse response) throws Exception {
        String localPath = this.localPath(request);
        IActiveEntityEventsListener[] listeners = this.activeNotificationHandler.getEventListeners();
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        ObjectNode resNode = om.createObjectNode();
        PrintWriter responseWriter = response.writer();
        try {
            response.setStatus(HttpResponseStatus.OK);
            int expireTime = localPath.length() == 0 || localPath.length() == 1 ? 2000 : Integer.valueOf(localPath.substring(1));
            long currentTime = System.currentTimeMillis();
            for (int iter1 = 0; iter1 < listeners.length; ++iter1) {
                resNode.putPOJO(listeners[iter1].getEntityId().toString(), (Object)this.constructNode(om, listeners[iter1], currentTime, expireTime));
            }
            responseWriter.write(om.writerWithDefaultPrettyPrinter().writeValueAsString((Object)resNode));
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "exception thrown for " + request, e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            responseWriter.write(e.toString());
        }
        responseWriter.flush();
    }
}

