/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.PathIsNotDirectoryException;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.fs.Trash;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class Delete {
    Delete() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Rm.class, "-rm");
        factory.addClass(Rmdir.class, "-rmdir");
        factory.addClass(Rmr.class, "-rmr");
        factory.addClass(Expunge.class, "-expunge");
    }

    static class Expunge
    extends FsCommand {
        public static final String NAME = "expunge";
        public static final String USAGE = "";
        public static final String DESCRIPTION = "Empty the Trash";

        Expunge() {
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(0, 0, new String[0]);
            cf.parse(args);
        }

        @Override
        protected void processArguments(LinkedList<PathData> args) throws IOException {
            Trash trash = new Trash(this.getConf());
            trash.expunge();
            trash.checkpoint();
        }
    }

    static class Rmdir
    extends FsCommand {
        public static final String NAME = "rmdir";
        public static final String USAGE = "[--ignore-fail-on-non-empty] <dir> ...";
        public static final String DESCRIPTION = "Removes the directory entry specified by each directory argument,\nprovided it is empty.\n";
        private boolean ignoreNonEmpty = false;

        Rmdir() {
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "-ignore-fail-on-non-empty");
            cf.parse(args);
            this.ignoreNonEmpty = cf.getOpt("-ignore-fail-on-non-empty");
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (!item.stat.isDirectory()) {
                throw new PathIsNotDirectoryException(item.toString());
            }
            if (item.fs.listStatus(item.path).length == 0) {
                if (!item.fs.delete(item.path, false)) {
                    throw new PathIOException(item.toString());
                }
            } else if (!this.ignoreNonEmpty) {
                throw new PathIsNotEmptyDirectoryException(item.toString());
            }
        }
    }

    static class Rmr
    extends Rm {
        public static final String NAME = "rmr";

        Rmr() {
        }

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            args.addFirst("-r");
            super.processOptions(args);
        }

        @Override
        public String getReplacementCommand() {
            return "rm -r";
        }
    }

    public static class Rm
    extends FsCommand {
        public static final String NAME = "rm";
        public static final String USAGE = "[-f] [-r|-R] [-skipTrash] <src> ...";
        public static final String DESCRIPTION = "Delete all files that match the specified file pattern.\nEquivalent to the Unix command \"rm <src>\"\n-skipTrash option bypasses trash, if enabled, and immediately\ndeletes <src>\n  -f     If the file does not exist, do not display a diagnostic\n         message or modify the exit status to reflect an error.\n  -[rR]  Recursively deletes directories";
        private boolean skipTrash = false;
        private boolean deleteDirs = false;
        private boolean ignoreFNF = false;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "f", "r", "R", "skipTrash");
            cf.parse(args);
            this.ignoreFNF = cf.getOpt("f");
            this.deleteDirs = cf.getOpt("r") || cf.getOpt("R");
            this.skipTrash = cf.getOpt("skipTrash");
        }

        @Override
        protected List<PathData> expandArgument(String arg) throws IOException {
            try {
                return super.expandArgument(arg);
            }
            catch (PathNotFoundException e) {
                if (!this.ignoreFNF) {
                    throw e;
                }
                return new LinkedList<PathData>();
            }
        }

        @Override
        protected void processNonexistentPath(PathData item) throws IOException {
            if (!this.ignoreFNF) {
                super.processNonexistentPath(item);
            }
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (item.stat.isDirectory() && !this.deleteDirs) {
                throw new PathIsDirectoryException(item.toString());
            }
            if (this.moveToTrash(item)) {
                return;
            }
            if (!item.fs.delete(item.path, this.deleteDirs)) {
                throw new PathIOException(item.toString());
            }
            this.out.println("Deleted " + item);
        }

        private boolean moveToTrash(PathData item) throws IOException {
            boolean success = false;
            if (!this.skipTrash) {
                try {
                    success = Trash.moveToAppropriateTrash(item.fs, item.path, this.getConf());
                }
                catch (FileNotFoundException fnfe) {
                    throw fnfe;
                }
                catch (IOException ioe) {
                    throw new IOException(ioe.getMessage() + ". Consider using -skipTrash option", ioe);
                }
            }
            return success;
        }
    }
}

