/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.job.listener;

import java.util.List;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.JobId;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.job.IJobletEventListener;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.JobStatus;

public class MultiTransactionJobletEventListenerFactory
implements IJobletEventListenerFactory {
    private static final long serialVersionUID = 1L;
    private final List<JobId> jobIds;
    private final boolean transactionalWrite;

    public MultiTransactionJobletEventListenerFactory(List<JobId> jobIds, boolean transactionalWrite) {
        this.jobIds = jobIds;
        this.transactionalWrite = transactionalWrite;
    }

    public IJobletEventListener createListener(final IHyracksJobletContext jobletContext) {
        return new IJobletEventListener(){

            public void jobletFinish(JobStatus jobStatus) {
                try {
                    ITransactionManager txnManager = ((INcApplicationContext)jobletContext.getServiceContext().getApplicationContext()).getTransactionSubsystem().getTransactionManager();
                    for (JobId jobId : MultiTransactionJobletEventListenerFactory.this.jobIds) {
                        ITransactionContext txnContext = txnManager.getTransactionContext(jobId, false);
                        txnContext.setWriteTxn(MultiTransactionJobletEventListenerFactory.this.transactionalWrite);
                        txnManager.completedTransaction(txnContext, DatasetId.NULL, -1, jobStatus != JobStatus.FAILURE);
                    }
                }
                catch (ACIDException e) {
                    throw new Error(e);
                }
            }

            public void jobletStart() {
                try {
                    for (JobId jobId : MultiTransactionJobletEventListenerFactory.this.jobIds) {
                        ((INcApplicationContext)jobletContext.getServiceContext().getApplicationContext()).getTransactionSubsystem().getTransactionManager().getTransactionContext(jobId, true);
                    }
                }
                catch (ACIDException e) {
                    throw new Error(e);
                }
            }
        };
    }
}

