/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class Substring2Descriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new Substring2Descriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable argString = new VoidPointable();
                    private IPointable argStart = new VoidPointable();
                    private IScalarEvaluator evalString;
                    private IScalarEvaluator evalStart;
                    private final GrowableArray array;
                    private final UTF8StringBuilder builder;
                    private final UTF8StringPointable string;
                    {
                        this.evalString = args[0].createScalarEvaluator(ctx);
                        this.evalStart = args[1].createScalarEvaluator(ctx);
                        this.array = new GrowableArray();
                        this.builder = new UTF8StringBuilder();
                        this.string = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.evalString.evaluate(tuple, this.argString);
                        this.evalStart.evaluate(tuple, this.argStart);
                        byte[] bytes = this.argStart.getByteArray();
                        int offset = this.argStart.getStartOffset();
                        int start = ATypeHierarchy.getIntegerValue((String)Substring2Descriptor.this.getIdentifier().getName(), (int)1, (byte[])bytes, (int)offset) - 1;
                        bytes = this.argString.getByteArray();
                        offset = this.argString.getStartOffset();
                        int len = this.argString.getLength();
                        if (bytes[offset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                            throw new TypeMismatchException(Substring2Descriptor.this.getIdentifier(), (Integer)0, bytes[offset], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                        }
                        this.string.set(bytes, offset + 1, len - 1);
                        this.array.reset();
                        try {
                            UTF8StringPointable.substr((UTF8StringPointable)this.string, (int)start, (int)Integer.MAX_VALUE, (UTF8StringBuilder)this.builder, (GrowableArray)this.array);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            throw new RuntimeDataException(11, new Serializable[]{Substring2Descriptor.this.getIdentifier(), Integer.valueOf(1), Integer.valueOf(start)});
                        }
                        catch (IOException e) {
                            throw new HyracksDataException((Throwable)e);
                        }
                        try {
                            this.out.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            this.out.write(this.array.getByteArray(), 0, this.array.getLength());
                        }
                        catch (IOException e) {
                            throw new HyracksDataException((Throwable)e);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.SUBSTRING2;
    }
}

