/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.util.Arrays;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;

public class StringEvaluatorUtils {
    static char[] reservedRegexChars = new char[]{'\\', '(', ')', '[', ']', '{', '}', '.', '^', '$', '*', '|'};

    public static int toFlag(String pattern) {
        int flag = 0;
        block6: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case 's': {
                    flag |= 0x20;
                    continue block6;
                }
                case 'm': {
                    flag |= 8;
                    continue block6;
                }
                case 'i': {
                    flag |= 2;
                    continue block6;
                }
                case 'x': {
                    flag |= 4;
                }
            }
        }
        return flag;
    }

    public static UTF8StringPointable copyResetUTF8Pointable(UTF8StringPointable srcString, ByteArrayAccessibleOutputStream destCopyStorage, UTF8StringPointable destString) {
        destCopyStorage.reset();
        destCopyStorage.write(srcString.getByteArray(), srcString.getStartOffset(), srcString.getMetaDataLength() + srcString.getUTF8Length());
        destString.set(destCopyStorage.getByteArray(), 0, destCopyStorage.size());
        return destString;
    }

    public static String toRegex(String pattern) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            if (c == '\\' && i < pattern.length() - 1 && (pattern.charAt(i + 1) == '_' || pattern.charAt(i + 1) == '%')) {
                sb.append(pattern.charAt(i + 1));
                ++i;
                continue;
            }
            if (c == '%') {
                sb.append(".*");
                continue;
            }
            if (c == '_') {
                sb.append(".");
                continue;
            }
            if (Arrays.binarySearch(reservedRegexChars, c) >= 0) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static {
        Arrays.sort(reservedRegexChars);
    }
}

