/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class SleepDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(SleepDescriptor.class.getSimpleName());
    public static final IFunctionDescriptorFactory FACTORY = SleepDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private IPointable argTime = new VoidPointable();
                    private final IScalarEvaluator evalValue;
                    private final IScalarEvaluator evalTime;
                    {
                        this.evalValue = args[0].createScalarEvaluator(ctx);
                        this.evalTime = args[1].createScalarEvaluator(ctx);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.evalValue.evaluate(tuple, result);
                        this.evalTime.evaluate(tuple, this.argTime);
                        byte[] bytes = this.argTime.getByteArray();
                        int offset = this.argTime.getStartOffset();
                        long time = ATypeHierarchy.getLongValue((String)SleepDescriptor.this.getIdentifier().getName(), (int)1, (byte[])bytes, (int)offset);
                        try {
                            if (LOGGER.isLoggable(Level.INFO)) {
                                LOGGER.log(Level.INFO, ctx.getTaskAttemptId() + " sleeping for " + time + " ms");
                            }
                            Thread.sleep(time);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        finally {
                            if (LOGGER.isLoggable(Level.INFO)) {
                                LOGGER.log(Level.INFO, ctx.getTaskAttemptId() + " done sleeping for " + time + " ms");
                            }
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.SLEEP;
    }
}

