/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityFiltersJaccard;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.PrefixLenJaccardDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class PrefixLenJaccardDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IPointable lenPtr = new VoidPointable();
    private final IPointable thresholdPtr = new VoidPointable();
    private final IScalarEvaluator evalLen;
    private final IScalarEvaluator evalThreshold;
    private float similarityThresholdCache;
    private SimilarityFiltersJaccard similarityFilters;
    private final AMutableInt32 res;
    private final ISerializerDeserializer<AInt32> int32Serde;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ PrefixLenJaccardDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    PrefixLenJaccardDescriptor$_EvaluatorGen(PrefixLenJaccardDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.evalLen = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.evalThreshold = this.this$1.val$args[1].createScalarEvaluator(this.val$ctx);
        this.res = new AMutableInt32(0);
        this.int32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int offset;
        this.resultStorage.reset();
        this.evalLen.evaluate(tuple, this.lenPtr);
        if (this.typeChecker.isMissing(this.lenPtr, result)) {
            return;
        }
        this.evalThreshold.evaluate(tuple, this.thresholdPtr);
        if (this.typeChecker.isMissing(this.thresholdPtr, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        int length = ATypeHierarchy.getIntegerValue((String)this.this$1.this$0.getIdentifier().getName(), (int)0, (byte[])this.lenPtr.getByteArray(), (int)this.lenPtr.getStartOffset());
        byte[] data = this.thresholdPtr.getByteArray();
        if (data[offset = this.thresholdPtr.getStartOffset()] != ATypeTag.SERIALIZED_FLOAT_TYPE_TAG) {
            throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)1, data[offset], ATypeTag.SERIALIZED_FLOAT_TYPE_TAG);
        }
        float similarityThreshold = AFloatSerializerDeserializer.getFloat((byte[])data, (int)(offset + 1));
        if (similarityThreshold != this.similarityThresholdCache || this.similarityFilters == null) {
            this.similarityFilters = new SimilarityFiltersJaccard(similarityThreshold);
        }
        int prefixLength = this.similarityFilters.getPrefixLength(length);
        this.res.setValue(prefixLength);
        try {
            this.int32Serde.serialize((Object)this.res, this.out);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

