/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.math.BigDecimal;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt16;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.functions.NumericTruncDescriptor$_Gen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class NumericTruncDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput out = this.resultStorage.getDataOutput();
    private final IPointable argValue = new VoidPointable();
    private final IPointable argPrecision = new VoidPointable();
    private final IScalarEvaluator eval;
    private final IScalarEvaluator precision;
    private final AMutableDouble aDouble = new AMutableDouble(0.0);
    private final AMutableFloat aFloat = new AMutableFloat(0.0f);
    private final AMutableInt64 aInt64 = new AMutableInt64(0L);
    private final AMutableInt32 aInt32 = new AMutableInt32(0);
    private final AMutableInt16 aInt16 = new AMutableInt16(0);
    private final AMutableInt8 aInt8 = new AMutableInt8(0);
    private ISerializerDeserializer serde;
    final /* synthetic */ NumericTruncDescriptor$_Gen this$0;
    private final TypeChecker typeChecker;

    NumericTruncDescriptor$_EvaluatorGen(NumericTruncDescriptor$_Gen this$0, IScalarEvaluatorFactory[] args, IHyracksTaskContext ctx) throws HyracksDataException {
        this.this$0 = this$0;
        this.eval = args[0].createScalarEvaluator(ctx);
        this.precision = args[1].createScalarEvaluator(ctx);
        this.typeChecker = new TypeChecker();
    }

    private int getPrecision() throws HyracksDataException {
        int offset;
        byte[] bytes = this.argPrecision.getByteArray();
        if (bytes[offset = this.argPrecision.getStartOffset()] == ATypeTag.SERIALIZED_INT8_TYPE_TAG) {
            return AInt8SerializerDeserializer.getByte((byte[])bytes, (int)(offset + 1));
        }
        if (bytes[offset] == ATypeTag.SERIALIZED_INT16_TYPE_TAG) {
            return AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(offset + 1));
        }
        if (bytes[offset] == ATypeTag.SERIALIZED_INT32_TYPE_TAG) {
            return AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(offset + 1));
        }
        if (bytes[offset] == ATypeTag.SERIALIZED_INT64_TYPE_TAG) {
            return (int)AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(offset + 1));
        }
        throw new TypeMismatchException(this.this$0.getIdentifier(), (Integer)1, bytes[offset], ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG);
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int offset;
        this.resultStorage.reset();
        this.eval.evaluate(tuple, this.argValue);
        if (this.typeChecker.isMissing(this.argValue, result)) {
            return;
        }
        this.precision.evaluate(tuple, this.argPrecision);
        if (this.typeChecker.isMissing(this.argPrecision, result)) {
            return;
        }
        if (this.typeChecker.isNull(result)) {
            return;
        }
        byte[] data = this.argValue.getByteArray();
        if (data[offset = this.argValue.getStartOffset()] == ATypeTag.SERIALIZED_INT8_TYPE_TAG) {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT8);
            byte val = AInt8SerializerDeserializer.getByte((byte[])data, (int)(offset + 1));
            this.aInt8.setValue(val);
            this.serde.serialize((Object)this.aInt8, this.out);
        } else if (data[offset] == ATypeTag.SERIALIZED_INT16_TYPE_TAG) {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT16);
            short val = AInt16SerializerDeserializer.getShort((byte[])data, (int)(offset + 1));
            this.aInt16.setValue(val);
            this.serde.serialize((Object)this.aInt16, this.out);
        } else if (data[offset] == ATypeTag.SERIALIZED_INT32_TYPE_TAG) {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
            int val = AInt32SerializerDeserializer.getInt((byte[])data, (int)(offset + 1));
            this.aInt32.setValue(val);
            this.serde.serialize((Object)this.aInt32, this.out);
        } else if (data[offset] == ATypeTag.SERIALIZED_INT64_TYPE_TAG) {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
            long val = AInt64SerializerDeserializer.getLong((byte[])data, (int)(offset + 1));
            this.aInt64.setValue(val);
            this.serde.serialize((Object)this.aInt64, this.out);
        } else if (data[offset] == ATypeTag.SERIALIZED_FLOAT_TYPE_TAG) {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
            float val = AFloatSerializerDeserializer.getFloat((byte[])data, (int)(offset + 1));
            if (Float.isNaN(val) || Float.isInfinite(val) || Float.compare(val, -0.0f) == 0 || Float.compare(val, 0.0f) == 0) {
                this.aFloat.setValue(val);
                this.serde.serialize((Object)this.aFloat, this.out);
            } else {
                BigDecimal r = new BigDecimal(Float.toString(val));
                this.aFloat.setValue(r.setScale(this.getPrecision(), 1).floatValue());
                this.serde.serialize((Object)this.aFloat, this.out);
            }
        } else if (data[offset] == ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
            double val = ADoubleSerializerDeserializer.getDouble((byte[])data, (int)(offset + 1));
            if (Double.isNaN(val) || Double.isInfinite(val) || Double.compare(val, -0.0) == 0 || Double.compare(val, 0.0) == 0) {
                this.aDouble.setValue(val);
                this.serde.serialize((Object)this.aDouble, this.out);
            } else {
                BigDecimal r = new BigDecimal(Double.toString(val));
                this.aDouble.setValue(r.setScale(this.getPrecision(), 1).doubleValue());
                this.serde.serialize((Object)this.aDouble, this.out);
            }
        } else {
            throw new TypeMismatchException(this.this$0.getIdentifier(), (Integer)0, data[offset], ATypeTag.SERIALIZED_INT8_TYPE_TAG, ATypeTag.SERIALIZED_INT16_TYPE_TAG, ATypeTag.SERIALIZED_INT32_TYPE_TAG, ATypeTag.SERIALIZED_INT64_TYPE_TAG, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
        }
        result.set((IValueReference)this.resultStorage);
    }
}

