/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AUnorderedListSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class AnyCollectionMemberDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new AnyCollectionMemberDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        return new AnyCollectionMemberEvalFactory(args[0]);
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ANY_COLLECTION_MEMBER;
    }

    private static class AnyCollectionMemberEvalFactory
    implements IScalarEvaluatorFactory {
        private static final long serialVersionUID = 1L;
        private IScalarEvaluatorFactory listEvalFactory;
        private byte serItemTypeTag;
        private ATypeTag itemTag;
        private boolean selfDescList = false;

        public AnyCollectionMemberEvalFactory(IScalarEvaluatorFactory arg) {
            this.listEvalFactory = arg;
        }

        public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
            return new IScalarEvaluator(){
                private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                private DataOutput out = this.resultStorage.getDataOutput();
                private IPointable inputArgList = new VoidPointable();
                private IScalarEvaluator evalList = AnyCollectionMemberEvalFactory.access$000(this).createScalarEvaluator(ctx);
                private int itemOffset;
                private int itemLength;

                public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                    this.resultStorage.reset();
                    this.evalList.evaluate(tuple, this.inputArgList);
                    byte[] serList = this.inputArgList.getByteArray();
                    int offset = this.inputArgList.getStartOffset();
                    if (serList[offset] != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG && serList[offset] != ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                        throw new TypeMismatchException(BuiltinFunctions.ANY_COLLECTION_MEMBER, (Integer)0, serList[offset], ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG);
                    }
                    try {
                        if (serList[offset] == ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
                            if (AOrderedListSerializerDeserializer.getNumberOfItems((byte[])serList, (int)offset) == 0) {
                                this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                                result.set((IValueReference)this.resultStorage);
                                return;
                            }
                            this.itemOffset = AOrderedListSerializerDeserializer.getItemOffset((byte[])serList, (int)offset, (int)0);
                        } else {
                            if (AUnorderedListSerializerDeserializer.getNumberOfItems((byte[])serList, (int)offset) == 0) {
                                this.out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                                result.set((IValueReference)this.resultStorage);
                                return;
                            }
                            this.itemOffset = AUnorderedListSerializerDeserializer.getItemOffset((byte[])serList, (int)offset, (int)0);
                        }
                        itemTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serList[offset + 1]);
                        if (itemTag == ATypeTag.ANY) {
                            selfDescList = true;
                        } else {
                            serItemTypeTag = serList[offset + 1];
                        }
                        if (selfDescList) {
                            itemTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serList[this.itemOffset]);
                            this.itemLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serList, (int)this.itemOffset, (ATypeTag)itemTag, (boolean)true) + 1;
                            result.set(serList, this.itemOffset, this.itemLength);
                        } else {
                            this.itemLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serList, (int)this.itemOffset, (ATypeTag)itemTag, (boolean)false);
                            this.out.writeByte(serItemTypeTag);
                            this.out.write(serList, this.itemOffset, this.itemLength);
                            result.set((IValueReference)this.resultStorage);
                        }
                    }
                    catch (IOException e) {
                        throw HyracksDataException.create((Throwable)e);
                    }
                }
            };
        }

        static /* synthetic */ IScalarEvaluatorFactory access$000(AnyCollectionMemberEvalFactory x0) {
            return x0.listEvalFactory;
        }
    }
}

