/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class AndDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new AndDescriptor();
        }
    };

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.AND;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                DataOutput out = resultStorage.getDataOutput();
                VoidPointable argPtr = new VoidPointable();
                final IScalarEvaluator[] evals = new IScalarEvaluator[args.length];
                for (int i = 0; i < evals.length; ++i) {
                    evals[i] = args[i].createScalarEvaluator(ctx);
                }
                return new IScalarEvaluator((IPointable)argPtr, out){
                    private ISerializerDeserializer<ABoolean> booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
                    private ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
                    private ISerializerDeserializer<AMissing> missingSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AMISSING);
                    final /* synthetic */ IPointable val$argPtr;
                    final /* synthetic */ DataOutput val$out;
                    {
                        this.val$argPtr = iPointable;
                        this.val$out = dataOutput;
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        resultStorage.reset();
                        int n = args.length;
                        boolean metNull = false;
                        boolean metMissing = false;
                        for (int i = 0; i < n; ++i) {
                            evals[i].evaluate(tuple, this.val$argPtr);
                            byte[] bytes = this.val$argPtr.getByteArray();
                            int offset = this.val$argPtr.getStartOffset();
                            boolean isNull = false;
                            boolean isMissing = false;
                            if (bytes[offset] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                                isMissing = true;
                                metMissing = true;
                            }
                            if (bytes[offset] == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
                                isNull = true;
                                metNull = true;
                            }
                            if (isMissing || isNull) continue;
                            if (bytes[offset] != ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG) {
                                throw new TypeMismatchException(AndDescriptor.this.getIdentifier(), (Integer)i, bytes[offset], ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG);
                            }
                            boolean argResult = ABooleanSerializerDeserializer.getBoolean((byte[])bytes, (int)(offset + 1));
                            if (argResult) continue;
                            this.booleanSerde.serialize((Object)ABoolean.FALSE, this.val$out);
                            result.set((IValueReference)resultStorage);
                            return;
                        }
                        if (metMissing) {
                            this.missingSerde.serialize((Object)AMissing.MISSING, this.val$out);
                        } else if (metNull) {
                            this.nullSerde.serialize((Object)ANull.NULL, this.val$out);
                        } else {
                            this.booleanSerde.serialize((Object)ABoolean.TRUE, this.val$out);
                        }
                        result.set((IValueReference)resultStorage);
                    }
                };
            }
        };
    }
}

