/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractInt64ConstructorEvaluator$_EvaluatorGen
implements IScalarEvaluator {
    protected static final ISerializerDeserializer<AInt64> INT64_SERDE = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    protected final IScalarEvaluator inputEval;
    protected final IPointable inputArg;
    protected final ArrayBackedValueStorage resultStorage;
    protected final DataOutput out;
    protected final AMutableInt64 aInt64;
    protected final UTF8StringPointable utf8Ptr;
    private final TypeChecker typeChecker;

    protected AbstractInt64ConstructorEvaluator$_EvaluatorGen(IScalarEvaluator inputEval) {
        this.inputEval = inputEval;
        this.inputArg = new VoidPointable();
        this.resultStorage = new ArrayBackedValueStorage();
        this.out = this.resultStorage.getDataOutput();
        this.aInt64 = new AMutableInt64(0L);
        this.utf8Ptr = new UTF8StringPointable();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.inputEval.evaluate(tuple, this.inputArg);
            if (this.typeChecker.isMissing(this.inputArg, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            this.resultStorage.reset();
            this.evaluateImpl(result);
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.getIdentifier(), e, ATypeTag.SERIALIZED_INT64_TYPE_TAG);
        }
    }

    protected void evaluateImpl(IPointable result) throws IOException {
        int startOffset;
        byte[] bytes = this.inputArg.getByteArray();
        byte tt = bytes[startOffset = this.inputArg.getStartOffset()];
        if (tt == ATypeTag.SERIALIZED_INT64_TYPE_TAG) {
            result.set((IValueReference)this.inputArg);
        } else if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            int len = this.inputArg.getLength();
            this.utf8Ptr.set(bytes, startOffset + 1, len - 1);
            int offset = this.utf8Ptr.getCharStartOffset();
            long value = 0L;
            boolean positive = true;
            long limit = -9223372036854775807L;
            if (bytes[offset] == 43) {
                ++offset;
            } else if (bytes[offset] == 45) {
                ++offset;
                positive = false;
                limit = Long.MIN_VALUE;
            }
            int end = startOffset + len;
            while (offset < end) {
                if (bytes[offset] < 48 || bytes[offset] > 57) {
                    if (bytes[offset] == 105 && bytes[offset + 1] == 54 && bytes[offset + 2] == 52 && offset + 3 == end) break;
                    this.handleUnparseableString(result);
                    return;
                }
                int digit = bytes[offset] - 48;
                if ((value *= 10L) < limit + (long)digit) {
                    this.handleUnparseableString(result);
                }
                value -= (long)digit;
                ++offset;
            }
            if (value > 0L) {
                this.handleUnparseableString(result);
            }
            if (value < 0L && positive) {
                value *= -1L;
            }
            this.aInt64.setValue(value);
            INT64_SERDE.serialize((Object)this.aInt64, this.out);
            result.set((IValueReference)this.resultStorage);
        } else {
            throw new TypeMismatchException(this.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
    }

    protected void handleUnparseableString(IPointable result) throws HyracksDataException {
        throw new InvalidDataFormatException(this.getIdentifier(), ATypeTag.SERIALIZED_INT64_TYPE_TAG);
    }

    protected abstract FunctionIdentifier getIdentifier();
}

