/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class AFloatConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new AFloatConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable inputArg = new VoidPointable();
                    private IScalarEvaluator eval;
                    private final byte[] POSITIVE_INF;
                    private final byte[] NEGATIVE_INF;
                    private final byte[] NAN;
                    private IBinaryComparator utf8BinaryComparator;
                    private AMutableFloat aFloat;
                    private ISerializerDeserializer<AFloat> floatSerde;
                    private final UTF8StringPointable utf8Ptr;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.POSITIVE_INF = UTF8StringUtil.writeStringToBytes((String)"INF");
                        this.NEGATIVE_INF = UTF8StringUtil.writeStringToBytes((String)"-INF");
                        this.NAN = UTF8StringUtil.writeStringToBytes((String)"NaN");
                        this.utf8BinaryComparator = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
                        this.aFloat = new AMutableFloat(0.0f);
                        this.floatSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
                        this.utf8Ptr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        block10: {
                            try {
                                this.eval.evaluate(tuple, this.inputArg);
                                byte[] serString = this.inputArg.getByteArray();
                                int offset = this.inputArg.getStartOffset();
                                int len = this.inputArg.getLength();
                                byte tt = serString[offset];
                                if (tt == ATypeTag.SERIALIZED_FLOAT_TYPE_TAG) {
                                    result.set((IValueReference)this.inputArg);
                                    break block10;
                                }
                                if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                    this.resultStorage.reset();
                                    if (this.utf8BinaryComparator.compare(serString, offset + 1, len - 1, this.POSITIVE_INF, 0, 5) == 0) {
                                        this.aFloat.setValue(Float.POSITIVE_INFINITY);
                                    } else if (this.utf8BinaryComparator.compare(serString, offset + 1, len - 1, this.NEGATIVE_INF, 0, 6) == 0) {
                                        this.aFloat.setValue(Float.NEGATIVE_INFINITY);
                                    } else if (this.utf8BinaryComparator.compare(serString, offset + 1, len - 1, this.NAN, 0, 5) == 0) {
                                        this.aFloat.setValue(Float.NaN);
                                    } else {
                                        this.utf8Ptr.set(serString, offset + 1, len - 1);
                                        this.aFloat.setValue(Float.parseFloat(this.utf8Ptr.toString()));
                                    }
                                    this.floatSerde.serialize((Object)this.aFloat, this.out);
                                    result.set((IValueReference)this.resultStorage);
                                    break block10;
                                }
                                throw new TypeMismatchException(AFloatConstructorDescriptor.this.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            catch (IOException e) {
                                throw new InvalidDataFormatException(AFloatConstructorDescriptor.this.getIdentifier(), e, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG);
                            }
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.FLOAT_CONSTRUCTOR;
    }
}

