/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ACircle;
import org.apache.asterix.om.base.AMutableCircle;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ACircleConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ACircleConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable inputArg = new VoidPointable();
                    private final IScalarEvaluator eval;
                    private final AMutablePoint aPoint;
                    private AMutableCircle aCircle;
                    private ISerializerDeserializer<ACircle> circleSerde;
                    private final UTF8StringPointable utf8Ptr;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.aPoint = new AMutablePoint(0.0, 0.0);
                        this.aCircle = new AMutableCircle(null, 0.0);
                        this.circleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ACIRCLE);
                        this.utf8Ptr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        block4: {
                            try {
                                this.eval.evaluate(tuple, this.inputArg);
                                byte[] serString = this.inputArg.getByteArray();
                                int offset = this.inputArg.getStartOffset();
                                int len = this.inputArg.getLength();
                                byte tt = serString[offset];
                                if (tt == ATypeTag.SERIALIZED_CIRCLE_TYPE_TAG) {
                                    result.set((IValueReference)this.inputArg);
                                    break block4;
                                }
                                if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                    this.resultStorage.reset();
                                    this.utf8Ptr.set(serString, offset + 1, len - 1);
                                    String s = this.utf8Ptr.toString();
                                    int commaIndex = s.indexOf(44);
                                    int spaceIndex = s.indexOf(32, commaIndex + 1);
                                    this.aPoint.setValue(Double.parseDouble(s.substring(0, commaIndex)), Double.parseDouble(s.substring(commaIndex + 1, spaceIndex)));
                                    this.aCircle.setValue((APoint)this.aPoint, Double.parseDouble(s.substring(spaceIndex + 1, s.length())));
                                    this.circleSerde.serialize((Object)this.aCircle, this.out);
                                    result.set((IValueReference)this.resultStorage);
                                    break block4;
                                }
                                throw new TypeMismatchException(ACircleConstructorDescriptor.this.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            catch (IOException e) {
                                throw new InvalidDataFormatException(ACircleConstructorDescriptor.this.getIdentifier(), e, ATypeTag.SERIALIZED_CIRCLE_TYPE_TAG);
                            }
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.CIRCLE_CONSTRUCTOR;
    }
}

