/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.comparisons;

import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.visitors.DeepEqualityVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;

public class DeepEqualAssessor {
    private static final String DEEP_EQUAL = "deep-equal";
    private static final double EPSILON = 1.0E-10;
    private final DeepEqualityVisitor equalityVisitor = new DeepEqualityVisitor();

    public boolean isEqual(IVisitablePointable leftPointable, IVisitablePointable rightPointable) throws HyracksDataException, AsterixException {
        ATypeTag rightTypeTag;
        if (leftPointable == null || rightPointable == null) {
            return false;
        }
        if (leftPointable.equals(rightPointable)) {
            return true;
        }
        ATypeTag leftTypeTag = PointableHelper.getTypeTag((IValueReference)leftPointable);
        if (leftTypeTag != (rightTypeTag = PointableHelper.getTypeTag((IValueReference)rightPointable))) {
            if (ATypeHierarchy.isSameTypeDomain((ATypeTag)leftTypeTag, (ATypeTag)rightTypeTag, (boolean)false) && ATypeHierarchy.getTypeDomain((ATypeTag)leftTypeTag) == ATypeHierarchy.Domain.NUMERIC) {
                double rightVal;
                double leftVal = ATypeHierarchy.getDoubleValue((String)DEEP_EQUAL, (int)0, (byte[])leftPointable.getByteArray(), (int)leftPointable.getStartOffset());
                return Math.abs(leftVal - (rightVal = ATypeHierarchy.getDoubleValue((String)DEEP_EQUAL, (int)1, (byte[])rightPointable.getByteArray(), (int)rightPointable.getStartOffset()))) < 1.0E-10;
            }
            return false;
        }
        Pair arg = new Pair((Object)rightPointable, (Object)Boolean.FALSE);
        leftPointable.accept((IVisitablePointableVisitor)this.equalityVisitor, (Object)arg);
        return (Boolean)arg.second;
    }
}

