/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.std;

import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.aggregates.std.AbstractSumAggregateFunction;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class SumAggregateFunction
extends AbstractSumAggregateFunction {
    private final boolean isLocalAgg;

    public SumAggregateFunction(IScalarEvaluatorFactory[] args, IHyracksTaskContext context, boolean isLocalAgg) throws HyracksDataException {
        super(args, context);
        this.isLocalAgg = isLocalAgg;
    }

    @Override
    protected boolean skipStep() {
        return this.aggType == ATypeTag.NULL;
    }

    @Override
    protected void processNull() {
        this.aggType = ATypeTag.NULL;
    }

    @Override
    protected void processSystemNull() throws HyracksDataException {
        if (this.isLocalAgg) {
            throw new UnsupportedItemTypeException(BuiltinFunctions.SUM, ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
        }
    }

    @Override
    protected void finishSystemNull() throws IOException {
        if (this.isLocalAgg) {
            this.resultStorage.getDataOutput().writeByte(ATypeTag.SYSTEM_NULL.serialize());
        } else {
            this.serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
            this.serde.serialize((Object)ANull.NULL, this.resultStorage.getDataOutput());
        }
    }
}

