/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.serializable.std;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.aggregates.serializable.std.BufferSerDeUtil;
import org.apache.asterix.runtime.evaluators.common.AccessibleByteArrayEval;
import org.apache.asterix.runtime.evaluators.common.ClosedRecordConstructorEvalFactory;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.ISerializedAggregateEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractSerializableAvgAggregateFunction
implements ISerializedAggregateEvaluator {
    private static final int SUM_FIELD_ID = 0;
    private static final int COUNT_FIELD_ID = 1;
    private static final int SUM_OFFSET = 0;
    private static final int COUNT_OFFSET = 8;
    protected static final int AGG_TYPE_OFFSET = 16;
    private IPointable inputVal = new VoidPointable();
    private IScalarEvaluator eval;
    private AMutableDouble aDouble = new AMutableDouble(0.0);
    private AMutableInt64 aInt64 = new AMutableInt64(0L);
    private IPointable avgBytes = new VoidPointable();
    private ByteArrayAccessibleOutputStream sumBytes = new ByteArrayAccessibleOutputStream();
    private DataOutput sumBytesOutput = new DataOutputStream((OutputStream)this.sumBytes);
    private ByteArrayAccessibleOutputStream countBytes = new ByteArrayAccessibleOutputStream();
    private DataOutput countBytesOutput = new DataOutputStream((OutputStream)this.countBytes);
    private IScalarEvaluator evalSum = new AccessibleByteArrayEval(this.sumBytes);
    private IScalarEvaluator evalCount = new AccessibleByteArrayEval(this.countBytes);
    private ClosedRecordConstructorEvalFactory.ClosedRecordConstructorEval recordEval;
    private ISerializerDeserializer<ADouble> doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    private ISerializerDeserializer<AInt64> longSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);

    public AbstractSerializableAvgAggregateFunction(IScalarEvaluatorFactory[] args, IHyracksTaskContext context) throws HyracksDataException {
        this.eval = args[0].createScalarEvaluator(context);
    }

    public void init(DataOutput state) throws HyracksDataException {
        try {
            state.writeDouble(0.0);
            state.writeLong(0L);
            state.writeByte(ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public abstract void step(IFrameTupleReference var1, byte[] var2, int var3, int var4) throws HyracksDataException;

    public abstract void finish(byte[] var1, int var2, int var3, DataOutput var4) throws HyracksDataException;

    public abstract void finishPartial(byte[] var1, int var2, int var3, DataOutput var4) throws HyracksDataException;

    protected abstract void processNull(byte[] var1, int var2);

    protected void processDataValues(IFrameTupleReference tuple, byte[] state, int start, int len) throws HyracksDataException {
        if (this.skipStep(state, start)) {
            return;
        }
        this.eval.evaluate(tuple, this.inputVal);
        byte[] bytes = this.inputVal.getByteArray();
        int offset = this.inputVal.getStartOffset();
        double sum = BufferSerDeUtil.getDouble(state, start + 0);
        long count = BufferSerDeUtil.getLong(state, start + 8);
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset]);
        ATypeTag aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 16]);
        if (typeTag == ATypeTag.MISSING || typeTag == ATypeTag.NULL) {
            this.processNull(state, start);
            return;
        }
        if (aggType == ATypeTag.SYSTEM_NULL) {
            aggType = typeTag;
        } else {
            if (typeTag != ATypeTag.SYSTEM_NULL && !ATypeHierarchy.isCompatible((ATypeTag)typeTag, (ATypeTag)aggType)) {
                throw new IncompatibleTypeException(BuiltinFunctions.AVG, bytes[offset], aggType.serialize());
            }
            if (ATypeHierarchy.canPromote((ATypeTag)aggType, (ATypeTag)typeTag)) {
                aggType = typeTag;
            }
        }
        ++count;
        switch (typeTag) {
            case TINYINT: {
                byte val = AInt8SerializerDeserializer.getByte((byte[])bytes, (int)(offset + 1));
                sum += (double)val;
                break;
            }
            case SMALLINT: {
                short val = AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(offset + 1));
                sum += (double)val;
                break;
            }
            case INTEGER: {
                int val = AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(offset + 1));
                sum += (double)val;
                break;
            }
            case BIGINT: {
                long val = AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(offset + 1));
                sum += (double)val;
                break;
            }
            case FLOAT: {
                float val = AFloatSerializerDeserializer.getFloat((byte[])bytes, (int)(offset + 1));
                sum += (double)val;
                break;
            }
            case DOUBLE: {
                double val = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1));
                sum += val;
                break;
            }
            default: {
                throw new UnsupportedItemTypeException(BuiltinFunctions.AVG, bytes[offset]);
            }
        }
        BufferSerDeUtil.writeDouble(sum, state, start + 0);
        BufferSerDeUtil.writeLong(count, state, start + 8);
        state[start + 16] = aggType.serialize();
    }

    protected void finishPartialResults(byte[] state, int start, int len, DataOutput result) throws HyracksDataException {
        double sum = BufferSerDeUtil.getDouble(state, start + 0);
        long count = BufferSerDeUtil.getLong(state, start + 8);
        ATypeTag aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 16]);
        if (this.recordEval == null) {
            ARecordType recType = new ARecordType(null, new String[]{"sum", "count"}, new IAType[]{BuiltinType.ADOUBLE, BuiltinType.AINT64}, false);
            this.recordEval = new ClosedRecordConstructorEvalFactory.ClosedRecordConstructorEval(recType, new IScalarEvaluator[]{this.evalSum, this.evalCount});
        }
        try {
            if (aggType == ATypeTag.SYSTEM_NULL) {
                GlobalConfig.ASTERIX_LOGGER.finest("AVG aggregate ran over empty input.");
                result.writeByte(ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
            } else if (aggType == ATypeTag.NULL) {
                result.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
            } else {
                this.sumBytes.reset();
                this.aDouble.setValue(sum);
                this.doubleSerde.serialize((Object)this.aDouble, this.sumBytesOutput);
                this.countBytes.reset();
                this.aInt64.setValue(count);
                this.longSerde.serialize((Object)this.aInt64, this.countBytesOutput);
                this.recordEval.evaluate(null, this.avgBytes);
                result.write(this.avgBytes.getByteArray(), this.avgBytes.getStartOffset(), this.avgBytes.getLength());
            }
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    protected void processPartialResults(IFrameTupleReference tuple, byte[] state, int start, int len) throws HyracksDataException {
        if (this.skipStep(state, start)) {
            return;
        }
        double sum = BufferSerDeUtil.getDouble(state, start + 0);
        long count = BufferSerDeUtil.getLong(state, start + 8);
        this.eval.evaluate(tuple, this.inputVal);
        byte[] serBytes = this.inputVal.getByteArray();
        int offset = this.inputVal.getStartOffset();
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serBytes[offset]);
        switch (typeTag) {
            case NULL: {
                this.processNull(state, start);
                break;
            }
            case SYSTEM_NULL: {
                break;
            }
            case OBJECT: {
                ATypeTag aggType = ATypeTag.DOUBLE;
                int nullBitmapSize = 0;
                int offset1 = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serBytes, (int)offset, (int)0, (int)nullBitmapSize, (boolean)false);
                int offset2 = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serBytes, (int)offset, (int)1, (int)nullBitmapSize, (boolean)false);
                BufferSerDeUtil.writeDouble(sum += ADoubleSerializerDeserializer.getDouble((byte[])serBytes, (int)offset1), state, start + 0);
                BufferSerDeUtil.writeLong(count += AInt64SerializerDeserializer.getLong((byte[])serBytes, (int)offset2), state, start + 8);
                state[start + 16] = aggType.serialize();
                break;
            }
            default: {
                throw new UnsupportedItemTypeException(BuiltinFunctions.AVG, serBytes[offset]);
            }
        }
    }

    protected void finishFinalResults(byte[] state, int start, int len, DataOutput result) throws HyracksDataException {
        double sum = BufferSerDeUtil.getDouble(state, start + 0);
        long count = BufferSerDeUtil.getLong(state, start + 8);
        ATypeTag aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 16]);
        try {
            if (count == 0L || aggType == ATypeTag.NULL) {
                this.nullSerde.serialize((Object)ANull.NULL, result);
            } else {
                this.aDouble.setValue(sum / (double)count);
                this.doubleSerde.serialize((Object)this.aDouble, result);
            }
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    protected boolean skipStep(byte[] state, int start) {
        return false;
    }
}

