/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataset.IDatasetPartitionManager;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.control.nc.Joblet;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.Task;

public class AbortAllTasksWork
extends SynchronizableWork {
    private static final Logger LOGGER = Logger.getLogger(AbortAllTasksWork.class.getName());
    private final NodeControllerService ncs;

    public AbortAllTasksWork(NodeControllerService ncs) {
        this.ncs = ncs;
    }

    protected void doRun() throws Exception {
        IDatasetPartitionManager dpm;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Aborting all tasks");
        }
        if ((dpm = this.ncs.getDatasetPartitionManager()) != null) {
            this.ncs.getDatasetPartitionManager().abortAllReaders();
        }
        for (Joblet ji : this.ncs.getJobletMap().values()) {
            Map<TaskAttemptId, Task> taskMap = ji.getTaskMap();
            for (Task task : taskMap.values()) {
                if (task == null) continue;
                task.abort();
            }
        }
    }
}

