/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.dataset;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataset.IDatasetManager;
import org.apache.hyracks.api.dataset.IDatasetPartitionManager;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.io.IWorkspaceFileFactory;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.common.dataset.ResultStateSweeper;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.dataset.DatasetMemoryManager;
import org.apache.hyracks.control.nc.dataset.DatasetPartitionReader;
import org.apache.hyracks.control.nc.dataset.DatasetPartitionWriter;
import org.apache.hyracks.control.nc.dataset.ResultSetMap;
import org.apache.hyracks.control.nc.dataset.ResultState;
import org.apache.hyracks.control.nc.io.WorkspaceFileFactory;
import org.apache.hyracks.control.nc.resources.DefaultDeallocatableRegistry;

public class DatasetPartitionManager
implements IDatasetPartitionManager {
    private static final Logger LOGGER = Logger.getLogger(DatasetPartitionManager.class.getName());
    private final NodeControllerService ncs;
    private final Executor executor;
    private final Map<JobId, ResultSetMap> partitionResultStateMap;
    private final DefaultDeallocatableRegistry deallocatableRegistry;
    private final IWorkspaceFileFactory fileFactory;
    private final DatasetMemoryManager datasetMemoryManager;

    public DatasetPartitionManager(NodeControllerService ncs, Executor executor, int availableMemory, long resultTTL, long resultSweepThreshold) {
        this.ncs = ncs;
        this.executor = executor;
        this.deallocatableRegistry = new DefaultDeallocatableRegistry();
        this.fileFactory = new WorkspaceFileFactory(this.deallocatableRegistry, ncs.getIoManager());
        this.datasetMemoryManager = availableMemory >= DatasetMemoryManager.getPageSize() ? new DatasetMemoryManager(availableMemory) : null;
        this.partitionResultStateMap = new LinkedHashMap<JobId, ResultSetMap>();
        executor.execute((Runnable)new ResultStateSweeper((IDatasetManager)this, resultTTL, resultSweepThreshold, LOGGER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFrameWriter createDatasetPartitionWriter(IHyracksTaskContext ctx, ResultSetId rsId, boolean orderedResult, boolean asyncMode, int partition, int nPartitions) throws HyracksException {
        DatasetPartitionWriter dpw;
        JobId jobId = ctx.getJobletContext().getJobId();
        DatasetPartitionManager datasetPartitionManager = this;
        synchronized (datasetPartitionManager) {
            dpw = new DatasetPartitionWriter(ctx, this, jobId, rsId, asyncMode, orderedResult, partition, nPartitions, this.datasetMemoryManager, this.fileFactory);
            ResultSetMap rsIdMap = this.partitionResultStateMap.computeIfAbsent(jobId, k -> new ResultSetMap());
            ResultState[] resultStates = rsIdMap.createOrGetResultStates(rsId, nPartitions);
            resultStates[partition] = dpw.getResultState();
        }
        LOGGER.fine("Initialized partition writer: JobId: " + jobId + ":partition: " + partition);
        return dpw;
    }

    public void registerResultPartitionLocation(JobId jobId, ResultSetId rsId, int partition, int nPartitions, boolean orderedResult, boolean emptyResult) throws HyracksException {
        try {
            this.ncs.getClusterController().registerResultPartitionLocation(jobId, rsId, orderedResult, emptyResult, partition, nPartitions, this.ncs.getDatasetNetworkManager().getPublicNetworkAddress());
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public void reportPartitionWriteCompletion(JobId jobId, ResultSetId rsId, int partition) throws HyracksException {
        try {
            LOGGER.fine("Reporting partition write completion: JobId: " + jobId + ": ResultSetId: " + rsId + ":partition: " + partition);
            this.ncs.getClusterController().reportResultPartitionWriteCompletion(jobId, rsId, partition);
        }
        catch (Exception e) {
            throw new HyracksException((Throwable)e);
        }
    }

    public void initializeDatasetPartitionReader(JobId jobId, ResultSetId resultSetId, int partition, IFrameWriter writer) throws HyracksException {
        ResultState resultState = this.getResultState(jobId, resultSetId, partition);
        DatasetPartitionReader dpr = new DatasetPartitionReader(this, this.datasetMemoryManager, this.executor, resultState);
        dpr.writeTo(writer);
        LOGGER.fine("Initialized partition reader: JobId: " + jobId + ":ResultSetId: " + resultSetId + ":partition: " + partition);
    }

    protected synchronized ResultState getResultState(JobId jobId, ResultSetId resultSetId, int partition) throws HyracksException {
        ResultSetMap rsIdMap = this.partitionResultStateMap.get(jobId);
        if (rsIdMap == null) {
            throw new HyracksException("Unknown JobId " + jobId);
        }
        ResultState[] resultStates = rsIdMap.getResultStates(resultSetId);
        if (resultStates == null) {
            throw new HyracksException("Unknown JobId: " + jobId + " ResultSetId: " + resultSetId);
        }
        ResultState resultState = resultStates[partition];
        if (resultState == null) {
            throw new HyracksException("No DatasetPartitionWriter for partition " + partition);
        }
        return resultState;
    }

    public synchronized void removePartition(JobId jobId, ResultSetId resultSetId, int partition) {
        ResultSetMap rsIdMap = this.partitionResultStateMap.get(jobId);
        if (rsIdMap != null && rsIdMap.removePartition(jobId, resultSetId, partition)) {
            this.partitionResultStateMap.remove(jobId);
        }
    }

    public synchronized void abortReader(JobId jobId) {
        ResultSetMap rsIdMap = this.partitionResultStateMap.get(jobId);
        if (rsIdMap != null) {
            rsIdMap.abortAll();
        }
    }

    public synchronized void abortAllReaders() {
        for (ResultSetMap rsIdMap : this.partitionResultStateMap.values()) {
            rsIdMap.abortAll();
        }
    }

    public synchronized void close() {
        for (JobId jobId : this.getJobIds()) {
            this.deinit(jobId);
        }
        this.deallocatableRegistry.close();
    }

    public synchronized Set<JobId> getJobIds() {
        return this.partitionResultStateMap.keySet();
    }

    public ResultSetMap getState(JobId jobId) {
        return this.partitionResultStateMap.get(jobId);
    }

    public synchronized long getResultTimestamp(JobId jobId) {
        ResultSetMap r = this.getState(jobId);
        if (r == null) {
            return -1L;
        }
        return r.getTimestamp();
    }

    public synchronized void deinitState(JobId jobId) {
        this.deinit(jobId);
        this.partitionResultStateMap.remove(jobId);
    }

    private synchronized void deinit(JobId jobId) {
        ResultSetMap rsIdMap = this.partitionResultStateMap.get(jobId);
        if (rsIdMap != null) {
            rsIdMap.closeAndDeleteAll();
        }
    }
}

