/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import org.apache.hyracks.control.common.ipc.CCNCFunctions;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.task.ShutdownTask;
import org.apache.hyracks.control.nc.task.ThreadDumpTask;
import org.apache.hyracks.control.nc.work.AbortTasksWork;
import org.apache.hyracks.control.nc.work.ApplicationMessageWork;
import org.apache.hyracks.control.nc.work.CleanupJobletWork;
import org.apache.hyracks.control.nc.work.DeployBinaryWork;
import org.apache.hyracks.control.nc.work.DestroyJobWork;
import org.apache.hyracks.control.nc.work.DistributeJobWork;
import org.apache.hyracks.control.nc.work.ReportPartitionAvailabilityWork;
import org.apache.hyracks.control.nc.work.StartTasksWork;
import org.apache.hyracks.control.nc.work.StateDumpWork;
import org.apache.hyracks.control.nc.work.UnDeployBinaryWork;
import org.apache.hyracks.ipc.api.IIPCHandle;
import org.apache.hyracks.ipc.api.IIPCI;

final class NodeControllerIPCI
implements IIPCI {
    private final NodeControllerService ncs;

    NodeControllerIPCI(NodeControllerService nodeControllerService) {
        this.ncs = nodeControllerService;
    }

    public void deliverIncomingMessage(IIPCHandle handle, long mid, long rmid, Object payload, Exception exception) {
        CCNCFunctions.Function fn = (CCNCFunctions.Function)payload;
        switch (fn.getFunctionId()) {
            case SEND_APPLICATION_MESSAGE: {
                CCNCFunctions.SendApplicationMessageFunction amf = (CCNCFunctions.SendApplicationMessageFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new ApplicationMessageWork(this.ncs, amf.getMessage(), amf.getDeploymentId(), amf.getNodeId()));
                return;
            }
            case START_TASKS: {
                CCNCFunctions.StartTasksFunction stf = (CCNCFunctions.StartTasksFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new StartTasksWork(this.ncs, stf.getDeploymentId(), stf.getJobId(), stf.getPlanBytes(), stf.getTaskDescriptors(), stf.getConnectorPolicies(), stf.getFlags()));
                return;
            }
            case ABORT_TASKS: {
                CCNCFunctions.AbortTasksFunction atf = (CCNCFunctions.AbortTasksFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new AbortTasksWork(this.ncs, atf.getJobId(), atf.getTasks()));
                return;
            }
            case CLEANUP_JOBLET: {
                CCNCFunctions.CleanupJobletFunction cjf = (CCNCFunctions.CleanupJobletFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new CleanupJobletWork(this.ncs, cjf.getJobId(), cjf.getStatus()));
                return;
            }
            case REPORT_PARTITION_AVAILABILITY: {
                CCNCFunctions.ReportPartitionAvailabilityFunction rpaf = (CCNCFunctions.ReportPartitionAvailabilityFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new ReportPartitionAvailabilityWork(this.ncs, rpaf.getPartitionId(), rpaf.getNetworkAddress()));
                return;
            }
            case NODE_REGISTRATION_RESULT: {
                CCNCFunctions.NodeRegistrationResult nrrf = (CCNCFunctions.NodeRegistrationResult)fn;
                this.ncs.setNodeRegistrationResult(nrrf.getNodeParameters(), nrrf.getException());
                return;
            }
            case GET_NODE_CONTROLLERS_INFO_RESPONSE: {
                CCNCFunctions.GetNodeControllersInfoResponseFunction gncirf = (CCNCFunctions.GetNodeControllersInfoResponseFunction)fn;
                this.ncs.setNodeControllersInfo(gncirf.getNodeControllerInfos());
                return;
            }
            case DEPLOY_BINARY: {
                CCNCFunctions.DeployBinaryFunction dbf = (CCNCFunctions.DeployBinaryFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new DeployBinaryWork(this.ncs, dbf.getDeploymentId(), dbf.getBinaryURLs()));
                return;
            }
            case UNDEPLOY_BINARY: {
                CCNCFunctions.UnDeployBinaryFunction ndbf = (CCNCFunctions.UnDeployBinaryFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new UnDeployBinaryWork(this.ncs, ndbf.getDeploymentId()));
                return;
            }
            case DISTRIBUTE_JOB: {
                CCNCFunctions.DistributeJobFunction djf = (CCNCFunctions.DistributeJobFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new DistributeJobWork(this.ncs, djf.getJobId(), djf.getacgBytes()));
                return;
            }
            case DESTROY_JOB: {
                CCNCFunctions.DestroyJobFunction dsjf = (CCNCFunctions.DestroyJobFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new DestroyJobWork(this.ncs, dsjf.getJobId()));
                return;
            }
            case STATE_DUMP_REQUEST: {
                CCNCFunctions.StateDumpRequestFunction dsrf = (CCNCFunctions.StateDumpRequestFunction)fn;
                this.ncs.getWorkQueue().schedule((AbstractWork)new StateDumpWork(this.ncs, dsrf.getStateDumpId()));
                return;
            }
            case SHUTDOWN_REQUEST: {
                CCNCFunctions.ShutdownRequestFunction sdrf = (CCNCFunctions.ShutdownRequestFunction)fn;
                this.ncs.getExecutor().submit(new ShutdownTask(this.ncs, sdrf.isTerminateNCService()));
                return;
            }
            case THREAD_DUMP_REQUEST: {
                CCNCFunctions.ThreadDumpRequestFunction tdrf = (CCNCFunctions.ThreadDumpRequestFunction)fn;
                this.ncs.getExecutor().submit(new ThreadDumpTask(this.ncs, tdrf.getRequestId()));
                return;
            }
        }
        throw new IllegalArgumentException("Unknown function: " + fn.getFunctionId());
    }
}

