/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hyracks.api.application.INCApplication;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.api.io.IFileDeviceResolver;
import org.apache.hyracks.api.job.resource.NodeCapacity;
import org.apache.hyracks.control.common.controllers.CCConfig;
import org.apache.hyracks.control.common.controllers.ControllerConfig;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.control.nc.io.DefaultDeviceResolver;

public class BaseNCApplication
implements INCApplication {
    public static final BaseNCApplication INSTANCE = new BaseNCApplication();

    protected BaseNCApplication() {
    }

    public void start(IServiceContext ncAppCtx, String[] args) throws Exception {
        if (args.length > 0) {
            throw new IllegalArgumentException("Unrecognized argument(s): " + Arrays.toString(args));
        }
    }

    public void startupCompleted() throws Exception {
    }

    public void onRegisterNode() throws Exception {
    }

    public void stop() throws Exception {
    }

    public void preStop() throws Exception {
    }

    public NodeCapacity getCapacity() {
        int allCores = ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
        return new NodeCapacity(Runtime.getRuntime().maxMemory(), allCores > 1 ? allCores - 1 : allCores);
    }

    public void registerConfig(IConfigManager configManager) {
        configManager.addIniParamOptions(new IOption[]{ControllerConfig.Option.CONFIG_FILE, ControllerConfig.Option.CONFIG_FILE_URL});
        configManager.addCmdLineSections(new Section[]{Section.NC, Section.COMMON, Section.LOCALNC});
        configManager.setUsageFilter(this.getUsageFilter());
        configManager.register(new Class[]{ControllerConfig.Option.class, CCConfig.Option.class, NCConfig.Option.class});
    }

    public Object getApplicationContext() {
        return null;
    }

    public IFileDeviceResolver getFileDeviceResolver() {
        return new DefaultDeviceResolver();
    }

    protected void configureLoggingLevel(Level level) {
        Logger.getLogger("org.apache.hyracks").setLevel(level);
    }
}

