/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.asterix.common.exceptions.AsterixException;
import twitter4j.DirectMessage;
import twitter4j.FilterQuery;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.UserStreamListener;
import twitter4j.conf.ConfigurationBuilder;

public class TwitterUtil {
    private static Logger LOGGER = Logger.getLogger(TwitterUtil.class.getName());

    private static Map<String, double[][]> initializeBoundingBoxes() {
        HashMap<String, double[][]> boundingBoxes = new HashMap<String, double[][]>();
        boundingBoxes.put("US", GeoConstants.US);
        boundingBoxes.put("Europe", GeoConstants.EU);
        return boundingBoxes;
    }

    public static double[][] getBoundingBoxes(String locationValue) throws AsterixException {
        double[][] locations = null;
        String coordRegex = "^((((\\-?\\d+\\.\\d+),\\s*){3}(\\-?\\d+\\.\\d+)|\\w+);\\s*)*(((\\-?\\d+\\.\\d+),\\s*){3}(\\-?\\d+\\.\\d+)|\\w+)$";
        Pattern p = Pattern.compile(coordRegex);
        Matcher m = p.matcher(locationValue);
        if (m.matches()) {
            String[] locationStrings = locationValue.trim().split(";\\s*");
            locations = new double[locationStrings.length * 2][2];
            for (int i = 0; i < locationStrings.length; ++i) {
                int l;
                int k;
                if (locationStrings[i].contains(",")) {
                    String[] coordinatesString = locationStrings[i].split(",");
                    for (k = 0; k < 2; ++k) {
                        for (l = 0; l < 2; ++l) {
                            try {
                                locations[2 * i + k][l] = Double.parseDouble(coordinatesString[2 * k + l]);
                                continue;
                            }
                            catch (NumberFormatException ne) {
                                throw new AsterixException("Incorrect coordinate value " + coordinatesString[2 * k + l]);
                            }
                        }
                    }
                    continue;
                }
                if (!GeoConstants.boundingBoxes.containsKey(locationStrings[i])) continue;
                double[][] loc = GeoConstants.boundingBoxes.get(locationStrings[i]);
                for (k = 0; k < 2; ++k) {
                    for (l = 0; l < 2; ++l) {
                        locations[2 * i + k][l] = loc[k][l];
                    }
                }
            }
        }
        return locations;
    }

    public static FilterQuery getFilterQuery(Map<String, String> configuration) throws AsterixException {
        String filterValue;
        double[][] locations;
        String locationValue = null;
        locationValue = configuration.containsKey("locations") ? configuration.get("locations") : configuration.get("location");
        String langValue = configuration.get("languages");
        String trackValue = configuration.get("keywords");
        FilterQuery filterQuery = null;
        if (trackValue != null) {
            String[] keywords = null;
            filterQuery = new FilterQuery();
            keywords = trackValue.contains(",") ? trackValue.trim().split(",\\s*") : new String[]{trackValue};
            filterQuery = filterQuery.track(keywords);
        }
        if (langValue != null) {
            if (filterQuery == null) {
                filterQuery = new FilterQuery();
            }
            String[] languages = langValue.contains(",") ? langValue.trim().split(",\\s*") : new String[]{langValue};
            filterQuery = filterQuery.language(languages);
        }
        if (locationValue != null && (locations = TwitterUtil.getBoundingBoxes(locationValue)) != null) {
            if (filterQuery == null) {
                filterQuery = new FilterQuery();
            }
            filterQuery = filterQuery.locations(locations);
        }
        if (filterQuery != null && (filterValue = configuration.get("filter-level")) != null) {
            filterQuery = filterQuery.filterLevel(filterValue);
        }
        return filterQuery;
    }

    public static Twitter getTwitterService(Map<String, String> configuration) {
        TwitterFactory tf;
        block2: {
            ConfigurationBuilder cb = TwitterUtil.getAuthConfiguration(configuration);
            tf = null;
            try {
                tf = new TwitterFactory(cb.build());
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block2;
                StringBuilder builder = new StringBuilder();
                builder.append("Twitter Adapter requires the following config parameters\n");
                builder.append("consumer.key\n");
                builder.append("consumer.secret\n");
                builder.append("access.token\n");
                builder.append("access.token.secret\n");
                LOGGER.warning(builder.toString());
                LOGGER.warning("Unable to configure Twitter adapter due to incomplete/incorrect authentication credentials");
                LOGGER.warning("For details on how to obtain OAuth authentication token, visit https://dev.twitter.com/oauth/overview/application-owner-access-tokens");
            }
        }
        Twitter twitter = tf.getInstance();
        return twitter;
    }

    public static TwitterStream getTwitterStream(Map<String, String> configuration) {
        ConfigurationBuilder cb = TwitterUtil.getAuthConfiguration(configuration);
        TwitterStreamFactory factory = new TwitterStreamFactory(cb.build());
        return factory.getInstance();
    }

    private static ConfigurationBuilder getAuthConfiguration(Map<String, String> configuration) {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.setDebugEnabled(true);
        cb.setJSONStoreEnabled(true);
        String oAuthConsumerKey = configuration.get("consumer.key");
        String oAuthConsumerSecret = configuration.get("consumer.secret");
        String oAuthAccessToken = configuration.get("access.token");
        String oAuthAccessTokenSecret = configuration.get("access.token.secret");
        cb.setOAuthConsumerKey(oAuthConsumerKey);
        cb.setOAuthConsumerSecret(oAuthConsumerSecret);
        cb.setOAuthAccessToken(oAuthAccessToken);
        cb.setOAuthAccessTokenSecret(oAuthAccessTokenSecret);
        TwitterUtil.configureProxy(cb, configuration);
        return cb;
    }

    private static void configureProxy(ConfigurationBuilder cb, Map<String, String> configuration) {
        String httpProxyHost = configuration.get("http-proxy-host");
        String httpProxyPort = configuration.get("http-proxy-port");
        if (httpProxyHost != null && httpProxyPort != null) {
            cb.setHttpProxyHost(httpProxyHost);
            cb.setHttpProxyPort(Integer.parseInt(httpProxyPort));
            String httpProxyUser = configuration.get("http-proxy-user");
            String httpProxyPassword = configuration.get("http-proxy-password");
            if (httpProxyUser != null && httpProxyPassword != null) {
                cb.setHttpProxyUser(httpProxyUser);
                cb.setHttpProxyPassword(httpProxyPassword);
            }
        }
    }

    public static void initializeConfigurationWithAuthInfo(Map<String, String> configuration) throws AsterixException {
        block11: {
            String authMode = configuration.get("authentication.mode");
            if (authMode == null) {
                authMode = "file";
            }
            try {
                switch (authMode) {
                    case "file": {
                        Properties prop = new Properties();
                        String authFile = configuration.get("authentication.file");
                        if (authFile == null) {
                            authFile = "/feed/twitter/auth.properties";
                        }
                        InputStream in = TwitterUtil.class.getResourceAsStream(authFile);
                        prop.load(in);
                        in.close();
                        configuration.put("consumer.key", prop.getProperty("consumer.key"));
                        configuration.put("consumer.secret", prop.getProperty("consumer.secret"));
                        configuration.put("access.token", prop.getProperty("access.token"));
                        configuration.put("access.token.secret", prop.getProperty("access.token.secret"));
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block11;
                LOGGER.warning("unable to load authentication credentials from auth.properties filecredential information will be obtained from adapter's configuration");
            }
        }
    }

    public static UserTweetsListener getUserTweetsListener() {
        return new UserTweetsListener();
    }

    public static TweetListener getTweetListener() {
        return new TweetListener();
    }

    static /* synthetic */ Map access$000() {
        return TwitterUtil.initializeBoundingBoxes();
    }

    public static class TweetListener
    implements StatusListener {
        private LinkedBlockingQueue<String> inputQ;

        public void setInputQ(LinkedBlockingQueue<String> inputQ) {
            this.inputQ = inputQ;
        }

        public void onStatus(Status tweet) {
            String jsonTweet = TwitterObjectFactory.getRawJSON((Object)tweet);
            this.inputQ.add(jsonTweet);
        }

        public void onException(Exception arg0) {
        }

        public void onDeletionNotice(StatusDeletionNotice arg0) {
        }

        public void onScrubGeo(long arg0, long arg1) {
        }

        public void onStallWarning(StallWarning arg0) {
        }

        public void onTrackLimitationNotice(int arg0) {
        }
    }

    public static class UserTweetsListener
    implements UserStreamListener {
        private LinkedBlockingQueue<String> inputQ;

        public void setInputQ(LinkedBlockingQueue<String> inputQ) {
            this.inputQ = inputQ;
        }

        public void onDeletionNotice(long l, long l1) {
        }

        public void onFriendList(long[] longs) {
        }

        public void onFavorite(User user, User user1, Status status) {
        }

        public void onUnfavorite(User user, User user1, Status status) {
        }

        public void onFollow(User user, User user1) {
        }

        public void onUnfollow(User user, User user1) {
        }

        public void onDirectMessage(DirectMessage directMessage) {
        }

        public void onUserListMemberAddition(User user, User user1, UserList userList) {
        }

        public void onUserListMemberDeletion(User user, User user1, UserList userList) {
        }

        public void onUserListSubscription(User user, User user1, UserList userList) {
        }

        public void onUserListUnsubscription(User user, User user1, UserList userList) {
        }

        public void onUserListCreation(User user, UserList userList) {
        }

        public void onUserListUpdate(User user, UserList userList) {
        }

        public void onUserListDeletion(User user, UserList userList) {
        }

        public void onUserProfileUpdate(User user) {
        }

        public void onUserSuspension(long l) {
        }

        public void onUserDeletion(long l) {
        }

        public void onBlock(User user, User user1) {
        }

        public void onUnblock(User user, User user1) {
        }

        public void onStatus(Status status) {
            String jsonTweet = TwitterObjectFactory.getRawJSON((Object)status);
            this.inputQ.add(jsonTweet);
        }

        public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
        }

        public void onTrackLimitationNotice(int i) {
        }

        public void onScrubGeo(long l, long l1) {
        }

        public void onStallWarning(StallWarning stallWarning) {
        }

        public void onException(Exception e) {
        }
    }

    public static final class SearchAPIConstants {
        public static final String QUERY = "query";
        public static final String INTERVAL = "interval";
    }

    public static final class AuthenticationConstants {
        public static final String OAUTH_CONSUMER_KEY = "consumer.key";
        public static final String OAUTH_CONSUMER_SECRET = "consumer.secret";
        public static final String OAUTH_ACCESS_TOKEN = "access.token";
        public static final String OAUTH_ACCESS_TOKEN_SECRET = "access.token.secret";
        public static final String OAUTH_AUTHENTICATION_FILE = "authentication.file";
        public static final String AUTHENTICATION_MODE = "authentication.mode";
        public static final String AUTHENTICATION_MODE_FILE = "file";
        public static final String AUTHENTICATION_MODE_EXPLICIT = "explicit";
        public static final String DEFAULT_AUTH_FILE = "/feed/twitter/auth.properties";
    }

    public static class GeoConstants {
        private static final double[][] US = new double[][]{{-124.848974, 24.396308}, {-66.885444, 49.384358}};
        private static final double[][] EU = new double[][]{{-29.7, 36.7}, {79.2, 72.0}};
        public static Map<String, double[][]> boundingBoxes = TwitterUtil.access$000();
    }

    public static class ConfigurationConstants {
        public static final String KEY_LOCATIONS = "locations";
        public static final String KEY_LOCATION = "location";
        public static final String LOCATION_US = "US";
        public static final String LOCATION_EU = "Europe";
        public static final String LANGUAGES = "languages";
        public static final String TRACK = "keywords";
        public static final String FILTER_LEVEL = "filter-level";
    }
}

