/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveManager;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.dataflow.LSMInsertDeleteOperatorNodePushable;
import org.apache.asterix.external.feed.dataflow.FeedRuntimeInputHandler;
import org.apache.asterix.external.feed.dataflow.SyncFeedRuntimeInputHandler;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.operators.FeedMetaOperatorDescriptor;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;

public class FeedMetaStoreNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    private static final Logger LOGGER = Logger.getLogger(FeedMetaStoreNodePushable.class.getName());
    private AbstractUnaryInputUnaryOutputOperatorNodePushable insertOperator;
    private final FeedPolicyAccessor policyAccessor;
    private final FeedConnectionId connectionId;
    private final int partition;
    private final FeedUtils.FeedRuntimeType runtimeType = FeedUtils.FeedRuntimeType.STORE;
    private final ActiveManager feedManager;
    private FrameTupleAccessor fta;
    private final IHyracksTaskContext ctx;
    private final VSizeFrame message;
    private final IRecordDescriptorProvider recordDescProvider;
    private final FeedMetaOperatorDescriptor opDesc;

    public FeedMetaStoreNodePushable(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions, IOperatorDescriptor coreOperator, FeedConnectionId feedConnectionId, Map<String, String> feedPolicyProperties, FeedMetaOperatorDescriptor feedMetaOperatorDescriptor) throws HyracksDataException {
        this.ctx = ctx;
        this.insertOperator = (AbstractUnaryInputUnaryOutputOperatorNodePushable)((IActivity)coreOperator).createPushRuntime(ctx, recordDescProvider, partition, nPartitions);
        this.policyAccessor = new FeedPolicyAccessor(feedPolicyProperties);
        this.partition = partition;
        this.connectionId = feedConnectionId;
        this.feedManager = (ActiveManager)((INcApplicationContext)ctx.getJobletContext().getServiceContext().getApplicationContext()).getActiveManager();
        this.message = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        TaskUtil.put((String)"HYX:MSG", (Object)this.message, (IHyracksTaskContext)ctx);
        this.recordDescProvider = recordDescProvider;
        this.opDesc = feedMetaOperatorDescriptor;
    }

    public void open() throws HyracksDataException {
        ActiveRuntimeId runtimeId = new ActiveRuntimeId(this.connectionId.getFeedId(), this.runtimeType.toString() + "." + this.connectionId.getDatasetName(), this.partition);
        try {
            this.initializeNewFeedRuntime(runtimeId);
            this.insertOperator.open();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to open feed store operator", e);
            throw new HyracksDataException((Throwable)e);
        }
    }

    private void initializeNewFeedRuntime(ActiveRuntimeId runtimeId) throws Exception {
        LSMInsertDeleteOperatorNodePushable indexOp;
        this.fta = new FrameTupleAccessor(this.recordDescProvider.getInputRecordDescriptor(this.opDesc.getActivityId(), 0));
        this.insertOperator.setOutputFrameWriter(0, this.writer, this.recordDesc);
        if (this.insertOperator instanceof LSMInsertDeleteOperatorNodePushable && !(indexOp = (LSMInsertDeleteOperatorNodePushable)this.insertOperator).isPrimary()) {
            this.writer = this.insertOperator;
            return;
        }
        this.writer = this.policyAccessor.flowControlEnabled() ? new FeedRuntimeInputHandler(this.ctx, this.connectionId, runtimeId, (IFrameWriter)this.insertOperator, this.policyAccessor, this.fta, this.feedManager.getFramePool()) : new SyncFeedRuntimeInputHandler(this.ctx, (IFrameWriter)this.insertOperator, this.fta);
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        try {
            FeedUtils.processFeedMessage(buffer, this.message, this.fta);
            this.writer.nextFrame(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void close() throws HyracksDataException {
        this.writer.close();
    }

    public void flush() throws HyracksDataException {
        this.writer.flush();
    }
}

