/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.io.Serializable;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.ActiveSourceOperatorNodePushable;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.external.dataset.adapter.FeedAdapter;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.feed.runtime.AdapterRuntimeManager;
import org.apache.asterix.external.operators.FeedIntakeOperatorDescriptor;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;

public class FeedIntakeOperatorNodePushable
extends ActiveSourceOperatorNodePushable {
    private final int partition;
    private final IAdapterFactory adapterFactory;
    private final FeedIntakeOperatorDescriptor opDesc;
    private volatile AdapterRuntimeManager adapterRuntimeManager;

    public FeedIntakeOperatorNodePushable(IHyracksTaskContext ctx, EntityId feedId, IAdapterFactory adapterFactory, int partition, FeedPolicyAccessor policyAccessor, IRecordDescriptorProvider recordDescProvider, FeedIntakeOperatorDescriptor feedIntakeOperatorDescriptor) {
        super(ctx, new ActiveRuntimeId(feedId, FeedIntakeOperatorNodePushable.class.getSimpleName(), partition));
        this.opDesc = feedIntakeOperatorDescriptor;
        this.recordDesc = recordDescProvider.getOutputRecordDescriptor(this.opDesc.getActivityId(), 0);
        this.partition = partition;
        this.adapterFactory = adapterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws HyracksDataException, InterruptedException {
        try {
            this.writer.open();
            Thread.currentThread().setName("Intake Thread");
            FeedAdapter adapter = (FeedAdapter)this.adapterFactory.createAdapter(this.ctx, this.partition);
            this.adapterRuntimeManager = new AdapterRuntimeManager(this.ctx, this.runtimeId.getEntityId(), adapter, this.writer, this.partition);
            VSizeFrame message = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
            TaskUtil.put((String)"HYX:MSG", (Object)message, (IHyracksTaskContext)this.ctx);
            message.getBuffer().put((byte)1);
            message.getBuffer().flip();
            this.adapterRuntimeManager.start();
            AdapterRuntimeManager adapterRuntimeManager = this.adapterRuntimeManager;
            synchronized (adapterRuntimeManager) {
                while (!this.adapterRuntimeManager.isDone()) {
                    this.adapterRuntimeManager.wait();
                }
            }
            if (this.adapterRuntimeManager.isFailed()) {
                throw new RuntimeDataException(3008, new Serializable[0]);
            }
        }
        catch (Exception e) {
            this.writer.fail();
            throw e;
        }
        finally {
            this.writer.close();
        }
    }

    protected void abort() throws HyracksDataException, InterruptedException {
        if (this.adapterRuntimeManager != null) {
            this.adapterRuntimeManager.stop();
        }
    }

    public String getStats() {
        if (this.adapterRuntimeManager != null) {
            return this.adapterRuntimeManager.getStats();
        }
        return "\"Runtime stats is not available.\"";
    }
}

