/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.java;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ACircleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AIntervalSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ALineSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APoint3DSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APointSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APolygonSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARectangleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ACircle;
import org.apache.asterix.om.base.ADate;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.ADuration;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.AInterval;
import org.apache.asterix.om.base.ALine;
import org.apache.asterix.om.base.AMissing;
import org.apache.asterix.om.base.AMutableCircle;
import org.apache.asterix.om.base.AMutableDate;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableDuration;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.base.AMutableInt16;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableInt8;
import org.apache.asterix.om.base.AMutableInterval;
import org.apache.asterix.om.base.AMutableLine;
import org.apache.asterix.om.base.AMutableOrderedList;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.AMutablePoint3D;
import org.apache.asterix.om.base.AMutablePolygon;
import org.apache.asterix.om.base.AMutableRecord;
import org.apache.asterix.om.base.AMutableRectangle;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AMutableTime;
import org.apache.asterix.om.base.AMutableUnorderedList;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.APoint3D;
import org.apache.asterix.om.base.APolygon;
import org.apache.asterix.om.base.ARectangle;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.ATime;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class JObjects {

    public static class ByteArrayAccessibleDataInputStream
    extends DataInputStream {
        public ByteArrayAccessibleDataInputStream(ByteArrayAccessibleInputStream in) {
            super(in);
        }

        public ByteArrayAccessibleInputStream getInputStream() {
            return (ByteArrayAccessibleInputStream)this.in;
        }
    }

    public static class ByteArrayAccessibleInputStream
    extends ByteArrayInputStream {
        public ByteArrayAccessibleInputStream(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        public void setContent(byte[] buf, int offset, int length) {
            this.buf = buf;
            this.pos = offset;
            this.count = Math.min(offset + length, buf.length);
            this.mark = offset;
        }

        public byte[] getArray() {
            return this.buf;
        }

        public int getPosition() {
            return this.pos;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static final class JRecord
    implements IJObject {
        private AMutableRecord value;
        private ARecordType recordType;
        private IJObject[] fields;
        private Map<String, IJObject> openFields;
        private final AStringSerializerDeserializer aStringSerDer = AStringSerializerDeserializer.INSTANCE;

        public JRecord(ARecordType recordType, IJObject[] fields) {
            this.recordType = recordType;
            this.fields = fields;
            this.openFields = new LinkedHashMap<String, IJObject>();
        }

        public JRecord(ARecordType recordType, IJObject[] fields, LinkedHashMap<String, IJObject> openFields) {
            this.recordType = recordType;
            this.fields = fields;
            this.openFields = openFields;
        }

        public void addField(String fieldName, IJObject fieldValue) throws HyracksDataException {
            int pos = this.getFieldPosByName(fieldName);
            if (pos >= 0) {
                throw new RuntimeDataException(3028, new Serializable[]{"closed"});
            }
            if (this.openFields.get(fieldName) != null) {
                throw new RuntimeDataException(3028, new Serializable[]{"open"});
            }
            this.openFields.put(fieldName, fieldValue);
        }

        public IJObject getValueByName(String fieldName) throws HyracksDataException {
            int fieldPos = this.getFieldPosByName(fieldName);
            if (fieldPos >= 0) {
                return this.fields[fieldPos];
            }
            IJObject fieldValue = this.openFields.get(fieldName);
            if (fieldValue == null) {
                throw new RuntimeDataException(3029, new Serializable[]{fieldName});
            }
            return fieldValue;
        }

        public void setValueAtPos(int pos, IJObject jObject) {
            this.fields[pos] = jObject;
        }

        @Override
        public ATypeTag getTypeTag() {
            return this.recordType.getTypeTag();
        }

        public void setField(String fieldName, IJObject fieldValue) throws HyracksDataException {
            int pos = this.getFieldPosByName(fieldName);
            if (pos >= 0) {
                this.fields[pos] = fieldValue;
            } else if (this.openFields.get(fieldName) != null) {
                this.openFields.put(fieldName, fieldValue);
            } else {
                throw new RuntimeDataException(3029, new Serializable[]{fieldName});
            }
        }

        private int getFieldPosByName(String fieldName) {
            String[] fieldNames;
            int index = 0;
            for (String name : fieldNames = this.recordType.getFieldNames()) {
                if (name.equals(fieldName)) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        public ARecordType getRecordType() {
            return this.recordType;
        }

        public IJObject[] getFields() {
            return this.fields;
        }

        public Map<String, IJObject> getOpenFields() {
            return this.openFields;
        }

        public RecordBuilder getRecordBuilder() {
            RecordBuilder recordBuilder = new RecordBuilder();
            recordBuilder.reset(this.recordType);
            return recordBuilder;
        }

        @Override
        public void serialize(DataOutput output, boolean writeTypeTag) throws HyracksDataException {
            RecordBuilder recordBuilder = new RecordBuilder();
            recordBuilder.reset(this.recordType);
            int index = 0;
            ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
            for (IJObject jObject : this.fields) {
                fieldValue.reset();
                jObject.serialize(fieldValue.getDataOutput(), writeTypeTag);
                recordBuilder.addField(index, (IValueReference)fieldValue);
                ++index;
            }
            try {
                if (this.openFields != null && !this.openFields.isEmpty()) {
                    ArrayBackedValueStorage openFieldName = new ArrayBackedValueStorage();
                    ArrayBackedValueStorage openFieldValue = new ArrayBackedValueStorage();
                    AMutableString nameValue = new AMutableString("");
                    for (Map.Entry<String, IJObject> entry : this.openFields.entrySet()) {
                        openFieldName.reset();
                        openFieldValue.reset();
                        nameValue.setValue(entry.getKey());
                        openFieldName.getDataOutput().write(ATypeTag.STRING.serialize());
                        this.aStringSerDer.serialize((AString)nameValue, openFieldName.getDataOutput());
                        entry.getValue().serialize(openFieldValue.getDataOutput(), true);
                        recordBuilder.addField((IValueReference)openFieldName, (IValueReference)openFieldValue);
                    }
                }
            }
            catch (IOException ae) {
                throw new HyracksDataException((Throwable)ae);
            }
            recordBuilder.write(output, writeTypeTag);
        }

        @Override
        public IAObject getIAObject() {
            return this.value;
        }

        @Override
        public void reset() throws HyracksDataException {
            if (this.openFields != null && !this.openFields.isEmpty()) {
                this.openFields.clear();
            }
            if (this.fields != null) {
                for (IJObject field : this.fields) {
                    if (field == null) continue;
                    field.reset();
                }
            }
        }

        public void reset(IJObject[] fields, LinkedHashMap<String, IJObject> openFields) throws HyracksDataException {
            this.reset();
            this.fields = fields;
            this.openFields = openFields;
        }
    }

    public static final class JUnorderedList
    extends JList {
        private AUnorderedListType listType;

        public JUnorderedList(IJObject jObject) {
            this.listType = new AUnorderedListType(jObject.getIAObject().getType(), null);
            this.jObjects = new ArrayList();
        }

        public JUnorderedList(IAType listItemType) {
            this.listType = new AUnorderedListType(listItemType, null);
            this.jObjects = new ArrayList();
        }

        @Override
        public void add(IJObject jObject) {
            this.jObjects.add(jObject);
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.MULTISET;
        }

        @Override
        public IAObject getIAObject() {
            AMutableUnorderedList v = new AMutableUnorderedList(this.listType);
            for (IJObject jObj : this.jObjects) {
                v.add(jObj.getIAObject());
            }
            return v;
        }

        public AUnorderedListType getListType() {
            return this.listType;
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            UnorderedListBuilder listBuilder = new UnorderedListBuilder();
            listBuilder.reset((AbstractCollectionType)this.listType);
            ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
            for (IJObject jObject : this.jObjects) {
                fieldValue.reset();
                jObject.serialize(fieldValue.getDataOutput(), true);
                listBuilder.addItem((IValueReference)fieldValue);
            }
            listBuilder.write(dataOutput, writeTypeTag);
        }

        @Override
        public void reset() {
            this.jObjects.clear();
        }
    }

    public static final class JOrderedList
    extends JList {
        private AOrderedListType listType;

        public JOrderedList(IJObject jObject) {
            this.listType = new AOrderedListType(jObject.getIAObject().getType(), null);
        }

        public JOrderedList(IAType listItemType) {
            this.listType = new AOrderedListType(listItemType, null);
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.ARRAY;
        }

        @Override
        public IAObject getIAObject() {
            AMutableOrderedList v = new AMutableOrderedList(this.listType);
            for (IJObject jObj : this.jObjects) {
                v.add(jObj.getIAObject());
            }
            return v;
        }

        public AOrderedListType getListType() {
            return this.listType;
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            UnorderedListBuilder listBuilder = new UnorderedListBuilder();
            listBuilder.reset((AbstractCollectionType)this.listType);
            ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
            for (IJObject jObject : this.jObjects) {
                fieldValue.reset();
                jObject.serialize(fieldValue.getDataOutput(), true);
                listBuilder.addItem((IValueReference)fieldValue);
            }
            listBuilder.write(dataOutput, writeTypeTag);
        }

        @Override
        public void reset() {
        }
    }

    public static abstract class JList
    implements IJObject {
        protected List<IJObject> jObjects = new ArrayList<IJObject>();

        public boolean isEmpty() {
            return this.jObjects.isEmpty();
        }

        public void add(IJObject jObject) {
            this.jObjects.add(jObject);
        }

        public void addAll(Collection<IJObject> jObjectCollection) {
            this.jObjects.addAll(jObjectCollection);
        }

        public void clear() {
            this.jObjects.clear();
        }

        public IJObject getElement(int index) {
            return this.jObjects.get(index);
        }

        public int size() {
            return this.jObjects.size();
        }

        public Iterator<IJObject> iterator() {
            return this.jObjects.iterator();
        }
    }

    public static final class JPoint3D
    extends JObject {
        public JPoint3D(double x, double y, double z) {
            super((IAObject)new AMutablePoint3D(x, y, z));
        }

        public void setValue(double x, double y, double z) {
            ((AMutablePoint3D)this.value).setValue(x, y, z);
        }

        public double getXValue() {
            return ((AMutablePoint3D)this.value).getX();
        }

        public double getYValue() {
            return ((AMutablePoint3D)this.value).getY();
        }

        public double getZValue() {
            return ((AMutablePoint3D)this.value).getZ();
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(ATypeTag.POINT3D.serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            APoint3DSerializerDeserializer.INSTANCE.serialize((APoint3D)((AMutablePoint3D)this.value), dataOutput);
        }

        @Override
        public void reset() {
        }
    }

    public static final class JLine
    extends JObject {
        public JLine(JPoint p1, JPoint p2) {
            super((IAObject)new AMutableLine((APoint)p1.getIAObject(), (APoint)p2.getIAObject()));
        }

        public void setValue(JPoint p1, JPoint p2) {
            ((AMutableLine)this.value).setValue((APoint)p1.getIAObject(), (APoint)p2.getIAObject());
        }

        public void setValue(APoint p1, APoint p2) {
            ((AMutableLine)this.value).setValue(p1, p2);
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(ATypeTag.LINE.serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            ALineSerializerDeserializer.INSTANCE.serialize((ALine)((AMutableLine)this.value), dataOutput);
        }

        @Override
        public void reset() {
        }
    }

    public static final class JCircle
    extends JObject {
        public JCircle(JPoint center, double radius) {
            super((IAObject)new AMutableCircle((APoint)center.getIAObject(), radius));
        }

        public void setValue(JPoint center, double radius) {
            ((AMutableCircle)this.value).setValue((APoint)center.getIAObject(), radius);
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.CIRCLE;
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(ATypeTag.CIRCLE.serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            ACircleSerializerDeserializer.INSTANCE.serialize((ACircle)((AMutableCircle)this.value), dataOutput);
        }

        @Override
        public void reset() {
        }
    }

    public static final class JPolygon
    extends JObject {
        public JPolygon(JPoint[] points) {
            super((IAObject)new AMutablePolygon(JPolygon.getAPoints(points)));
        }

        public void setValue(APoint[] points) {
            ((AMutablePolygon)this.value).setValue(points);
        }

        public void setValue(JPoint[] points) {
            ((AMutablePolygon)this.value).setValue(JPolygon.getAPoints(points));
        }

        private static APoint[] getAPoints(JPoint[] jpoints) {
            APoint[] apoints = new APoint[jpoints.length];
            int index = 0;
            for (JPoint jpoint : jpoints) {
                apoints[index++] = (APoint)jpoint.getIAObject();
            }
            return apoints;
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.POLYGON;
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(ATypeTag.POLYGON.serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            APolygonSerializerDeserializer.INSTANCE.serialize((APolygon)((AMutablePolygon)this.value), dataOutput);
        }

        @Override
        public void reset() {
            ((AMutablePolygon)this.value).setValue(null);
        }
    }

    public static final class JDuration
    extends JObject {
        public JDuration(int months, long milliseconds) {
            super((IAObject)new AMutableDuration(months, milliseconds));
        }

        public void setValue(int months, long milliseconds) {
            ((AMutableDuration)this.value).setValue(months, milliseconds);
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(ATypeTag.DURATION.serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            ADurationSerializerDeserializer.INSTANCE.serialize((ADuration)((AMutableDuration)this.value), dataOutput);
        }

        @Override
        public void reset() {
            ((AMutableDuration)this.value).setValue(0, 0L);
        }
    }

    public static final class JDateTime
    extends JObject {
        public JDateTime(long chrononTime) {
            super((IAObject)new AMutableDateTime(chrononTime));
        }

        public void setValue(long chrononTime) {
            ((AMutableDateTime)this.value).setValue(chrononTime);
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(ATypeTag.DATETIME.serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            ADateTimeSerializerDeserializer.INSTANCE.serialize((ADateTime)((AMutableDateTime)this.value), dataOutput);
        }

        @Override
        public void reset() {
            ((AMutableDateTime)this.value).setValue(0L);
        }
    }

    public static final class JDate
    extends JObject {
        public JDate(int chrononTimeInDays) {
            super((IAObject)new AMutableDate(chrononTimeInDays));
        }

        public void setValue(int chrononTimeInDays) {
            ((AMutableDate)this.value).setValue(chrononTimeInDays);
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(ATypeTag.DATE.serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            ADateSerializerDeserializer.INSTANCE.serialize((ADate)((AMutableDate)this.value), dataOutput);
        }

        @Override
        public void reset() {
            ((AMutableDate)this.value).setValue(0);
        }
    }

    public static final class JInterval
    extends JObject {
        public JInterval(long intervalStart, long intervalEnd) {
            super((IAObject)new AMutableInterval(intervalStart, intervalEnd, 0));
        }

        public void setValue(long intervalStart, long intervalEnd, byte typetag) throws HyracksDataException {
            ((AMutableInterval)this.value).setValue(intervalStart, intervalEnd, typetag);
        }

        public long getIntervalStart() {
            return ((AMutableInterval)this.value).getIntervalStart();
        }

        public long getIntervalEnd() {
            return ((AMutableInterval)this.value).getIntervalEnd();
        }

        public short getIntervalType() {
            return ((AMutableInterval)this.value).getIntervalType();
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(ATypeTag.INTERVAL.serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            AIntervalSerializerDeserializer.INSTANCE.serialize((AInterval)((AMutableInterval)this.value), dataOutput);
        }

        @Override
        public void reset() throws HyracksDataException {
            ((AMutableInterval)this.value).setValue(0L, 0L, (byte)0);
        }
    }

    public static final class JTime
    extends JObject {
        public JTime(int timeInMillsec) {
            super((IAObject)new AMutableTime(timeInMillsec));
        }

        public void setValue(int timeInMillsec) {
            ((AMutableTime)this.value).setValue(timeInMillsec);
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(ATypeTag.TIME.serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            ATimeSerializerDeserializer.INSTANCE.serialize((ATime)((AMutableTime)this.value), dataOutput);
        }

        @Override
        public void reset() {
            ((AMutableTime)this.value).setValue(0);
        }
    }

    public static final class JRectangle
    extends JObject {
        public JRectangle(JPoint p1, JPoint p2) {
            super((IAObject)new AMutableRectangle((APoint)p1.getIAObject(), (APoint)p2.getIAObject()));
        }

        public void setValue(JPoint p1, JPoint p2) {
            ((AMutableRectangle)this.value).setValue((APoint)p1.getValue(), (APoint)p2.getValue());
        }

        public void setValue(APoint p1, APoint p2) {
            ((AMutableRectangle)this.value).setValue(p1, p2);
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.RECTANGLE;
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(this.value.getType().getTypeTag().serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            ARectangleSerializerDeserializer.INSTANCE.serialize((ARectangle)this.value, dataOutput);
        }

        @Override
        public void reset() {
        }
    }

    public static final class JPoint
    extends JObject {
        public JPoint(double x, double y) {
            super((IAObject)new AMutablePoint(x, y));
        }

        public void setValue(double x, double y) {
            ((AMutablePoint)this.value).setValue(x, y);
        }

        public double getXValue() {
            return ((AMutablePoint)this.value).getX();
        }

        public double getYValue() {
            return ((AMutablePoint)this.value).getY();
        }

        public IAObject getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(this.value.getType().getTypeTag().serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            APointSerializerDeserializer.INSTANCE.serialize((APoint)this.value, dataOutput);
        }

        @Override
        public void reset() {
            ((AMutablePoint)this.value).setValue(0.0, 0.0);
        }
    }

    public static final class JFloat
    extends JObject {
        public JFloat(float v) {
            super((IAObject)new AMutableFloat(v));
        }

        public void setValue(float v) {
            ((AMutableFloat)this.value).setValue(v);
        }

        public float getValue() {
            return ((AMutableFloat)this.value).getFloatValue();
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(this.value.getType().getTypeTag().serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            AFloatSerializerDeserializer.INSTANCE.serialize((AFloat)this.value, dataOutput);
        }

        @Override
        public void reset() {
            ((AMutableFloat)this.value).setValue(0.0f);
        }
    }

    public static final class JString
    extends JObject {
        private final AStringSerializerDeserializer aStringSerDer = AStringSerializerDeserializer.INSTANCE;

        public JString(String v) {
            super((IAObject)new AMutableString(v));
        }

        public void setValue(String v) {
            ((AMutableString)this.value).setValue(v);
        }

        public String getValue() {
            return ((AMutableString)this.value).getStringValue();
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(this.value.getType().getTypeTag().serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            this.aStringSerDer.serialize((AString)this.value, dataOutput);
        }

        @Override
        public void reset() {
            ((AMutableString)this.value).setValue("");
        }
    }

    public static final class JDouble
    extends JObject {
        public JDouble(double v) {
            super((IAObject)new AMutableDouble(v));
        }

        public void setValue(double v) {
            ((AMutableDouble)this.value).setValue(v);
        }

        public double getValue() {
            return ((AMutableDouble)this.value).getDoubleValue();
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(this.value.getType().getTypeTag().serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            ADoubleSerializerDeserializer.INSTANCE.serialize((ADouble)this.value, dataOutput);
        }

        @Override
        public void reset() {
            ((AMutableDouble)this.value).setValue(0.0);
        }
    }

    public static final class JLong
    extends JObject {
        public JLong(long v) {
            super((IAObject)new AMutableInt64(v));
        }

        public void setValue(long v) {
            ((AMutableInt64)this.value).setValue(v);
        }

        public long getValue() {
            return ((AMutableInt64)this.value).getLongValue();
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(this.value.getType().getTypeTag().serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            AInt64SerializerDeserializer.INSTANCE.serialize((AInt64)this.value, dataOutput);
        }

        @Override
        public void reset() {
            ((AMutableInt64)this.value).setValue(0L);
        }
    }

    public static final class JBoolean
    implements IJObject {
        private boolean value;

        public JBoolean(boolean value) {
            this.value = value;
        }

        public void setValue(boolean value) {
            this.value = value;
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.BOOLEAN;
        }

        @Override
        public IAObject getIAObject() {
            return this.value ? ABoolean.TRUE : ABoolean.FALSE;
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(ATypeTag.BOOLEAN.serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            ABooleanSerializerDeserializer.INSTANCE.serialize((ABoolean)this.getIAObject(), dataOutput);
        }

        @Override
        public void reset() {
            this.value = false;
        }
    }

    public static final class JInt
    extends JObject {
        public JInt(int value) {
            super((IAObject)new AMutableInt32(value));
        }

        public void setValue(int v) {
            ((AMutableInt32)this.value).setValue(v);
        }

        public int getValue() {
            return ((AMutableInt32)this.value).getIntegerValue();
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(this.value.getType().getTypeTag().serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            AInt32SerializerDeserializer.INSTANCE.serialize((AInt32)this.value, dataOutput);
        }

        @Override
        public void reset() {
            ((AMutableInt32)this.value).setValue(0);
        }
    }

    public static final class JShort
    extends JObject {
        private AMutableInt16 value;

        public JShort(short value) {
            super((IAObject)new AMutableInt16(value));
        }

        public void setValue(byte v) {
            this.value.setValue((short)v);
        }

        public short getValue() {
            return this.value.getShortValue();
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(this.value.getType().getTypeTag().serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            AInt16SerializerDeserializer.INSTANCE.serialize((AInt16)this.value, dataOutput);
        }

        @Override
        public void reset() {
            this.value.setValue((short)0);
        }
    }

    public static final class JByte
    extends JObject {
        public JByte(byte value) {
            super((IAObject)new AMutableInt8(value));
        }

        public void setValue(byte v) {
            ((AMutableInt8)this.value).setValue(v);
        }

        public byte getValue() {
            return ((AMutableInt8)this.value).getByteValue();
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(this.value.getType().getTypeTag().serialize());
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
            AInt8SerializerDeserializer.INSTANCE.serialize((AInt8)this.value, dataOutput);
        }

        @Override
        public void reset() {
            ((AMutableInt8)this.value).setValue((byte)0);
        }
    }

    public static class JMissing
    implements IJObject {
        public static final JMissing INSTANCE = new JMissing();

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.MISSING;
        }

        @Override
        public IAObject getIAObject() {
            return AMissing.MISSING;
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        }

        @Override
        public void reset() throws HyracksDataException {
        }
    }

    public static class JNull
    implements IJObject {
        public static final JNull INSTANCE = new JNull();

        private JNull() {
        }

        @Override
        public ATypeTag getTypeTag() {
            return ATypeTag.NULL;
        }

        @Override
        public IAObject getIAObject() {
            return ANull.NULL;
        }

        @Override
        public void serialize(DataOutput dataOutput, boolean writeTypeTag) throws HyracksDataException {
            if (writeTypeTag) {
                try {
                    dataOutput.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }
        }

        @Override
        public void reset() {
        }
    }

    public static abstract class JObject
    implements IJObject {
        protected IAObject value;
        protected byte[] bytes;

        protected JObject(IAObject value) {
            this.value = value;
        }

        @Override
        public ATypeTag getTypeTag() {
            return this.value.getType().getTypeTag();
        }

        @Override
        public IAObject getIAObject() {
            return this.value;
        }
    }
}

