/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.java;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.serde.ABooleanSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ACircleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AIntervalSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ALineSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APoint3DSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APointSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APolygonSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARectangleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.external.api.IJListAccessor;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.api.IJObjectAccessor;
import org.apache.asterix.external.api.IJRecordAccessor;
import org.apache.asterix.external.library.TypeInfo;
import org.apache.asterix.external.library.java.JObjectPointableVisitor;
import org.apache.asterix.external.library.java.JObjectUtil;
import org.apache.asterix.external.library.java.JObjects;
import org.apache.asterix.om.base.ACircle;
import org.apache.asterix.om.base.ADuration;
import org.apache.asterix.om.base.ALine;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.APoint3D;
import org.apache.asterix.om.base.APolygon;
import org.apache.asterix.om.base.ARectangle;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.string.UTF8StringReader;

public class JObjectAccessors {
    public static IJObjectAccessor createFlatJObjectAccessor(ATypeTag aTypeTag) {
        IJObjectAccessor accessor = null;
        switch (aTypeTag) {
            case BOOLEAN: {
                accessor = new JBooleanAccessor();
                break;
            }
            case TINYINT: {
                accessor = new JInt8Accessor();
                break;
            }
            case SMALLINT: {
                accessor = new JInt16Accessor();
                break;
            }
            case INTEGER: {
                accessor = new JInt32Accessor();
                break;
            }
            case BIGINT: {
                accessor = new JInt64Accessor();
                break;
            }
            case FLOAT: {
                accessor = new JFloatAccessor();
                break;
            }
            case DOUBLE: {
                accessor = new JDoubleAccessor();
                break;
            }
            case STRING: {
                accessor = new JStringAccessor();
                break;
            }
            case POINT: {
                accessor = new JPointAccessor();
                break;
            }
            case POINT3D: {
                accessor = new JPoint3DAccessor();
                break;
            }
            case LINE: {
                accessor = new JLineAccessor();
                break;
            }
            case DATE: {
                accessor = new JDateAccessor();
                break;
            }
            case DATETIME: {
                accessor = new JDateTimeAccessor();
                break;
            }
            case DURATION: {
                accessor = new JDurationAccessor();
                break;
            }
            case NULL: {
                accessor = new JNullAccessor();
                break;
            }
            case MISSING: {
                accessor = new JMissingAccessor();
                break;
            }
        }
        return accessor;
    }

    public static class JUnorderedListAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            return null;
        }
    }

    public static class JListAccessor
    implements IJListAccessor {
        private final TypeInfo typeInfo;

        public JListAccessor(IObjectPool<IJObject, IAType> objectPool) {
            this.typeInfo = new TypeInfo(objectPool, null, null);
        }

        @Override
        public IJObject access(AListVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool, IAType listType, JObjectPointableVisitor pointableVisitor) throws HyracksDataException {
            List items = pointable.getItems();
            List itemTags = pointable.getItemTags();
            JObjects.JList list = pointable.ordered() ? new JObjects.JOrderedList(listType) : new JObjects.JUnorderedList(listType);
            int index = 0;
            try {
                for (IVisitablePointable itemPointable : items) {
                    IJObject listItem;
                    IVisitablePointable itemTagPointable = (IVisitablePointable)itemTags.get(index);
                    ATypeTag itemTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(itemTagPointable.getByteArray()[itemTagPointable.getStartOffset()]);
                    IAType fieldType = TypeTagUtil.getBuiltinTypeByTag((ATypeTag)itemTypeTag);
                    this.typeInfo.reset(fieldType, itemTypeTag);
                    switch (itemTypeTag) {
                        case OBJECT: {
                            listItem = pointableVisitor.visit((ARecordVisitablePointable)itemPointable, this.typeInfo);
                            break;
                        }
                        case ARRAY: 
                        case MULTISET: {
                            listItem = pointableVisitor.visit((AListVisitablePointable)itemPointable, this.typeInfo);
                            break;
                        }
                        case ANY: {
                            throw new RuntimeDataException(3039, new Serializable[]{listType.getTypeTag()});
                        }
                        default: {
                            listItem = pointableVisitor.visit((AFlatValuePointable)itemPointable, this.typeInfo);
                        }
                    }
                    list.add(listItem);
                }
            }
            catch (AsterixException exception) {
                throw new HyracksDataException((Throwable)exception);
            }
            return list;
        }
    }

    public static class JRecordAccessor
    implements IJRecordAccessor {
        private final TypeInfo typeInfo;
        private final JObjects.JRecord jRecord;
        private final IJObject[] jObjects;
        private final LinkedHashMap<String, IJObject> openFields;
        private final UTF8StringReader reader = new UTF8StringReader();

        public JRecordAccessor(ARecordType recordType, IObjectPool<IJObject, IAType> objectPool) {
            this.typeInfo = new TypeInfo(objectPool, null, null);
            this.jObjects = new IJObject[recordType.getFieldNames().length];
            this.jRecord = new JObjects.JRecord(recordType, this.jObjects);
            this.openFields = new LinkedHashMap();
        }

        @Override
        public JObjects.JRecord access(ARecordVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool, ARecordType recordType, JObjectPointableVisitor pointableVisitor) throws HyracksDataException {
            this.jRecord.reset();
            ARecordVisitablePointable recordPointable = pointable;
            List fieldPointables = recordPointable.getFieldValues();
            List fieldTypeTags = recordPointable.getFieldTypeTags();
            List fieldNames = recordPointable.getFieldNames();
            int index = 0;
            try {
                IJObject fieldObject = null;
                for (IVisitablePointable fieldPointable : fieldPointables) {
                    boolean closedPart = index < recordType.getFieldTypes().length;
                    IVisitablePointable tt = (IVisitablePointable)fieldTypeTags.get(index);
                    ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(tt.getByteArray()[tt.getStartOffset()]);
                    IAType fieldType = closedPart ? recordType.getFieldTypes()[index] : TypeTagUtil.getBuiltinTypeByTag((ATypeTag)typeTag);
                    IVisitablePointable fieldName = (IVisitablePointable)fieldNames.get(index);
                    this.typeInfo.reset(fieldType, typeTag);
                    switch (typeTag) {
                        case OBJECT: {
                            fieldObject = pointableVisitor.visit((ARecordVisitablePointable)fieldPointable, this.typeInfo);
                            break;
                        }
                        case ARRAY: 
                        case MULTISET: {
                            if (fieldPointable instanceof AFlatValuePointable) {
                                fieldObject = null;
                                break;
                            }
                            fieldObject = pointableVisitor.visit((AListVisitablePointable)fieldPointable, this.typeInfo);
                            break;
                        }
                        case ANY: {
                            break;
                        }
                        default: {
                            fieldObject = pointableVisitor.visit((AFlatValuePointable)fieldPointable, this.typeInfo);
                        }
                    }
                    if (closedPart) {
                        this.jObjects[index] = fieldObject;
                    } else {
                        byte[] b = fieldName.getByteArray();
                        int s = fieldName.getStartOffset();
                        int l = fieldName.getLength();
                        String v = this.reader.readUTF((DataInput)new DataInputStream(new ByteArrayInputStream(b, s + 1, l - 1)));
                        this.openFields.put(v, fieldObject);
                    }
                    ++index;
                    fieldObject = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new HyracksDataException((Throwable)e);
            }
            return this.jRecord;
        }

        public void reset() throws HyracksDataException {
            this.jRecord.reset();
            this.openFields.clear();
        }
    }

    public static class JRectangleAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int l = pointable.getLength();
            ARectangle v = ARectangleSerializerDeserializer.INSTANCE.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(b, s, l)));
            JObjects.JRectangle jObject = (JObjects.JRectangle)objectPool.allocate((Object)BuiltinType.ARECTANGLE);
            jObject.setValue(v.getP1(), v.getP2());
            return jObject;
        }
    }

    public static class JPolygonAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int l = pointable.getLength();
            APolygon v = APolygonSerializerDeserializer.INSTANCE.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(b, s, l)));
            JObjects.JPolygon jObject = (JObjects.JPolygon)objectPool.allocate((Object)BuiltinType.APOLYGON);
            jObject.setValue(v.getPoints());
            return jObject;
        }
    }

    public static class JLineAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int l = pointable.getLength();
            ALine v = ALineSerializerDeserializer.INSTANCE.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(b, s, l)));
            JObjects.JLine jObject = (JObjects.JLine)objectPool.allocate((Object)BuiltinType.ALINE);
            jObject.setValue(v.getP1(), v.getP2());
            return jObject;
        }
    }

    public static class JPoint3DAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int l = pointable.getLength();
            APoint3D v = APoint3DSerializerDeserializer.INSTANCE.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(b, s, l)));
            JObjects.JPoint3D jObject = (JObjects.JPoint3D)objectPool.allocate((Object)BuiltinType.APOINT3D);
            jObject.setValue(v.getX(), v.getY(), v.getZ());
            return jObject;
        }
    }

    public static class JPointAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int l = pointable.getLength();
            APoint v = APointSerializerDeserializer.INSTANCE.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(b, s, l)));
            JObjects.JPoint jObject = (JObjects.JPoint)objectPool.allocate((Object)BuiltinType.APOINT);
            jObject.setValue(v.getX(), v.getY());
            return jObject;
        }
    }

    public static class JCircleAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int l = pointable.getLength();
            ACircle v = ACircleSerializerDeserializer.INSTANCE.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(b, s, l)));
            JObjects.JPoint jpoint = (JObjects.JPoint)objectPool.allocate((Object)BuiltinType.APOINT);
            jpoint.setValue(v.getP().getX(), v.getP().getY());
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ACIRCLE);
            ((JObjects.JCircle)jObject).setValue(jpoint, v.getRadius());
            return jObject;
        }
    }

    public static class JIntervalAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            long intervalStart = AIntervalSerializerDeserializer.getIntervalStart((byte[])b, (int)s);
            long intervalEnd = AIntervalSerializerDeserializer.getIntervalEnd((byte[])b, (int)s);
            byte intervalType = AIntervalSerializerDeserializer.getIntervalTimeType((byte[])b, (int)s);
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AINTERVAL);
            ((JObjects.JInterval)jObject).setValue(intervalStart, intervalEnd, intervalType);
            return jObject;
        }
    }

    public static class JTimeAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int v = ATimeSerializerDeserializer.getChronon((byte[])b, (int)s);
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ATIME);
            ((JObjects.JTime)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JDurationAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int l = pointable.getLength();
            ADuration duration = ADurationSerializerDeserializer.INSTANCE.deserialize((DataInput)new DataInputStream(new ByteArrayInputStream(b, s, l)));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ADURATION);
            ((JObjects.JDuration)jObject).setValue(duration.getMonths(), duration.getMilliseconds());
            return jObject;
        }
    }

    public static class JDateTimeAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            long v = ADateTimeSerializerDeserializer.getChronon((byte[])b, (int)s);
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ADATETIME);
            ((JObjects.JDateTime)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JDateAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int v = ADateSerializerDeserializer.getChronon((byte[])b, (int)s);
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ADATE);
            ((JObjects.JDate)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JBooleanAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            Boolean v = ABooleanSerializerDeserializer.getBoolean((byte[])b, (int)s);
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ABOOLEAN);
            ((JObjects.JBoolean)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JStringAccessor
    implements IJObjectAccessor {
        private final UTF8StringReader reader = new UTF8StringReader();

        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int l = pointable.getLength();
            String v = null;
            try {
                v = this.reader.readUTF((DataInput)new DataInputStream(new ByteArrayInputStream(b, s + 1, l - 1)));
            }
            catch (IOException e) {
                throw new HyracksDataException((Throwable)e);
            }
            JObjectUtil.getNormalizedString(v);
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ASTRING);
            ((JObjects.JString)jObject).setValue(JObjectUtil.getNormalizedString(v));
            return jObject;
        }
    }

    public static class JDoubleAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            double v = ADoubleSerializerDeserializer.getDouble((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ADOUBLE);
            ((JObjects.JDouble)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JFloatAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            float v = AFloatSerializerDeserializer.getFloat((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AFLOAT);
            ((JObjects.JFloat)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JInt64Accessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            long v = AInt64SerializerDeserializer.getLong((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AINT64);
            ((JObjects.JLong)jObject).setValue(v);
            return jObject;
        }
    }

    public static class JMissingAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objPool) throws HyracksDataException {
            IJObject jObject = (IJObject)objPool.allocate((Object)BuiltinType.AMISSING);
            return jObject;
        }
    }

    public static class JNullAccessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objPool) throws HyracksDataException {
            IJObject jObject = (IJObject)objPool.allocate((Object)BuiltinType.ANULL);
            return jObject;
        }
    }

    public static class JInt32Accessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            int i = AInt32SerializerDeserializer.getInt((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AINT32);
            ((JObjects.JInt)jObject).setValue(i);
            return jObject;
        }
    }

    public static class JInt16Accessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            short i = AInt16SerializerDeserializer.getShort((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AINT16);
            ((JObjects.JInt)jObject).setValue(i);
            return null;
        }
    }

    public static class JInt8Accessor
    implements IJObjectAccessor {
        @Override
        public IJObject access(IVisitablePointable pointable, IObjectPool<IJObject, IAType> objectPool) throws HyracksDataException {
            byte[] b = pointable.getByteArray();
            int s = pointable.getStartOffset();
            byte o = AInt8SerializerDeserializer.getByte((byte[])b, (int)(s + 1));
            IJObject jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AINT8);
            ((JObjects.JByte)jObject).setValue(o);
            return null;
        }
    }
}

