/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.library.ExternalScalarFunctionDescriptor;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;

public class RuntimeExternalFunctionUtil {
    private static Map<String, ClassLoader> libraryClassLoaders = new HashMap<String, ClassLoader>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLibraryClassLoader(String dataverseName, String libraryName, ClassLoader classLoader) throws RuntimeDataException {
        String key = dataverseName + "." + libraryName;
        Map<String, ClassLoader> map = libraryClassLoaders;
        synchronized (map) {
            if (libraryClassLoaders.get(dataverseName) != null) {
                throw new RuntimeDataException(3044, new Serializable[0]);
            }
            libraryClassLoaders.put(key, classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getLibraryClassLoader(String dataverseName, String libraryName) {
        String key = dataverseName + "." + libraryName;
        Map<String, ClassLoader> map = libraryClassLoaders;
        synchronized (map) {
            return libraryClassLoaders.get(key);
        }
    }

    public static IFunctionDescriptor getFunctionDescriptor(IFunctionInfo finfo, IApplicationContext appCtx) throws RuntimeDataException {
        switch (((IExternalFunctionInfo)finfo).getKind()) {
            case SCALAR: {
                return RuntimeExternalFunctionUtil.getScalarFunctionDescriptor(finfo, appCtx);
            }
            case AGGREGATE: 
            case UNNEST: 
            case STATEFUL: {
                throw new RuntimeDataException(3047, new Serializable[]{finfo.getFunctionIdentifier().getName()});
            }
        }
        return null;
    }

    private static AbstractScalarFunctionDynamicDescriptor getScalarFunctionDescriptor(IFunctionInfo finfo, IApplicationContext appCtx) {
        return new ExternalScalarFunctionDescriptor(finfo, appCtx);
    }

    public static ByteBuffer allocateArgumentBuffers(IAType type) {
        switch (type.getTypeTag()) {
            case INTEGER: {
                return ByteBuffer.allocate(4);
            }
            case STRING: {
                return ByteBuffer.allocate(32768);
            }
        }
        return ByteBuffer.allocate(32768);
    }

    public static IAObject allocateArgumentObjects(IAType type) {
        switch (type.getTypeTag()) {
            case INTEGER: {
                return new AMutableInt32(0);
            }
            case STRING: {
                return new AMutableString("");
            }
        }
        return null;
    }
}

