/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.external.api.IExternalFunction;
import org.apache.asterix.external.api.IFunctionFactory;
import org.apache.asterix.external.api.IFunctionHelper;
import org.apache.asterix.external.library.JavaFunctionHelper;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IDataOutputProvider;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class ExternalFunction
implements IExternalFunction {
    protected final IExternalFunctionInfo finfo;
    protected final IFunctionFactory externalFunctionFactory;
    protected final IExternalFunction externalFunction;
    protected final IScalarEvaluatorFactory[] evaluatorFactories;
    protected final IPointable inputVal = new VoidPointable();
    protected final ArrayBackedValueStorage resultBuffer = new ArrayBackedValueStorage();
    protected final ArrayBackedValueStorage castBuffer = new ArrayBackedValueStorage();
    protected final IScalarEvaluator[] argumentEvaluators;
    protected final JavaFunctionHelper functionHelper;

    public ExternalFunction(IExternalFunctionInfo finfo, IScalarEvaluatorFactory[] args, IHyracksTaskContext context, IApplicationContext appCtx) throws HyracksDataException {
        this.finfo = finfo;
        this.evaluatorFactories = args;
        this.argumentEvaluators = new IScalarEvaluator[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.argumentEvaluators[i] = args[i].createScalarEvaluator(context);
        }
        this.functionHelper = new JavaFunctionHelper(finfo, (IDataOutputProvider)this.resultBuffer);
        String[] fnameComponents = finfo.getFunctionIdentifier().getName().split("#");
        String functionLibary = fnameComponents[0];
        String dataverse = finfo.getFunctionIdentifier().getNamespace();
        ILibraryManager libraryManager = appCtx.getLibraryManager();
        ClassLoader libraryClassLoader = libraryManager.getLibraryClassLoader(dataverse, functionLibary);
        String classname = finfo.getFunctionBody().trim();
        try {
            Class<?> clazz = Class.forName(classname, true, libraryClassLoader);
            this.externalFunctionFactory = (IFunctionFactory)clazz.newInstance();
            this.externalFunction = this.externalFunctionFactory.getExternalFunction();
        }
        catch (Exception e) {
            throw new RuntimeDataException(3041, (Throwable)e, new Serializable[]{classname});
        }
    }

    public static ISerializerDeserializer<?> getSerDe(Object typeInfo) {
        return SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer(typeInfo);
    }

    public IExternalFunctionInfo getFinfo() {
        return this.finfo;
    }

    public void setArguments(IFrameTupleReference tuple) throws AlgebricksException, IOException {
        for (int i = 0; i < this.evaluatorFactories.length; ++i) {
            this.argumentEvaluators[i].evaluate(tuple, this.inputVal);
            ATypeTag targetTypeTag = ((IAType)this.finfo.getParamList().get(i)).getTypeTag();
            ATypeTag sourceTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.inputVal.getByteArray()[this.inputVal.getStartOffset()]);
            if (sourceTypeTag != targetTypeTag) {
                this.castBuffer.reset();
                ATypeHierarchy.convertNumericTypeByteArray((byte[])this.inputVal.getByteArray(), (int)this.inputVal.getStartOffset(), (int)this.inputVal.getLength(), (ATypeTag)targetTypeTag, (DataOutput)this.castBuffer.getDataOutput(), (boolean)true);
                this.functionHelper.setArgument(i, (IValueReference)this.castBuffer);
                continue;
            }
            this.functionHelper.setArgument(i, (IValueReference)this.inputVal);
        }
    }

    @Override
    public void deinitialize() {
        this.externalFunction.deinitialize();
    }

    @Override
    public void initialize(IFunctionHelper functionHelper) throws Exception {
        this.externalFunction.initialize(functionHelper);
    }
}

