/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.input.stream.TwitterFirehoseInputStream;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class TwitterFirehoseStreamFactory
implements IInputStreamFactory {
    private static final long serialVersionUID = 1L;
    private static final String KEY_INGESTION_CARDINALITY = "ingestion-cardinality";
    private static final String KEY_INGESTION_LOCATIONS = "ingestion-location";
    private Map<String, String> configuration;

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() {
        int count;
        String ingestionCardinalityParam = this.configuration.get(KEY_INGESTION_CARDINALITY);
        String ingestionLocationParam = this.configuration.get(KEY_INGESTION_LOCATIONS);
        String[] locations = null;
        if (ingestionLocationParam != null) {
            locations = ingestionLocationParam.split(",");
        }
        int n = count = locations != null ? locations.length : 1;
        if (ingestionCardinalityParam != null) {
            count = Integer.parseInt(ingestionCardinalityParam);
        }
        ArrayList<String> chosenLocations = new ArrayList<String>();
        String[] availableLocations = locations != null ? locations : ClusterStateManager.INSTANCE.getParticipantNodes().toArray(new String[0]);
        int k = 0;
        for (int i = 0; i < count; ++i) {
            chosenLocations.add(availableLocations[k]);
            k = (k + 1) % availableLocations.length;
        }
        return new AlgebricksAbsolutePartitionConstraint(chosenLocations.toArray(new String[0]));
    }

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.STREAM;
    }

    @Override
    public void configure(IServiceContext serviceCtx, Map<String, String> configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean isIndexible() {
        return false;
    }

    @Override
    public AsterixInputStream createInputStream(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        try {
            return new TwitterFirehoseInputStream(this.configuration, partition);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }
}

