/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.generator.TweetGenerator;

public class TwitterFirehoseInputStream
extends AsterixInputStream {
    private static final Logger LOGGER = Logger.getLogger(TwitterFirehoseInputStream.class.getName());
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final PipedOutputStream outputStream = new PipedOutputStream();
    private final PipedInputStream inputStream = new PipedInputStream(this.outputStream);
    private final DataProvider dataProvider;
    private boolean started;

    public TwitterFirehoseInputStream(Map<String, String> configuration, int partition) throws IOException {
        this.dataProvider = new DataProvider(configuration, partition, this.outputStream);
        this.started = false;
    }

    @Override
    public boolean stop() throws IOException {
        this.dataProvider.stop();
        return true;
    }

    public synchronized void start() {
        if (!this.started) {
            this.executorService.execute(this.dataProvider);
            this.started = true;
        }
    }

    @Override
    public int read() throws IOException {
        if (!this.started) {
            this.start();
        }
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.started) {
            this.start();
        }
        return this.inputStream.read(b, off, len);
    }

    @Override
    public boolean handleException(Throwable th) {
        return false;
    }

    private static class DataProvider
    implements Runnable {
        public static final String KEY_MODE = "mode";
        private final TweetGenerator tweetGenerator;
        private boolean continuePush = true;
        private int batchSize;
        private final Mode mode;
        private final OutputStream os;

        public DataProvider(Map<String, String> configuration, int partition, OutputStream os) {
            this.tweetGenerator = new TweetGenerator(configuration, partition);
            this.tweetGenerator.registerSubscriber(os);
            this.os = os;
            this.mode = configuration.get(KEY_MODE) != null ? Mode.valueOf(configuration.get(KEY_MODE).toUpperCase()) : Mode.AGGRESSIVE;
            switch (this.mode) {
                case CONTROLLED: {
                    String tpsValue = configuration.get("tps");
                    if (tpsValue == null) {
                        throw new IllegalArgumentException("TPS value not configured. use tps=<value>");
                    }
                    this.batchSize = Integer.parseInt(tpsValue);
                    break;
                }
                case AGGRESSIVE: {
                    this.batchSize = 5000;
                }
            }
        }

        @Override
        public void run() {
            boolean moreData = true;
            while (true) {
                try {
                    while (moreData && this.continuePush) {
                        switch (this.mode) {
                            case AGGRESSIVE: {
                                moreData = this.tweetGenerator.generateNextBatch(this.batchSize);
                                break;
                            }
                            case CONTROLLED: {
                                long startBatch = System.currentTimeMillis();
                                moreData = this.tweetGenerator.generateNextBatch(this.batchSize);
                                long endBatch = System.currentTimeMillis();
                                if (endBatch - startBatch >= 1000L) break;
                                Thread.sleep(1000L - (endBatch - startBatch));
                            }
                        }
                    }
                    this.os.close();
                }
                catch (Exception e) {
                    LOGGER.warning("Exception in adapter " + e.getMessage());
                    continue;
                }
                break;
            }
        }

        public void stop() {
            this.continuePush = false;
        }

        public static enum Mode {
            AGGRESSIVE,
            CONTROLLED;

        }
    }
}

