/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.asterix.external.util.FileSystemWatcher;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.log4j.Logger;

public class LocalFSInputStream
extends AsterixInputStream {
    private static final Logger LOGGER = Logger.getLogger((String)LocalFSInputStream.class.getName());
    private final FileSystemWatcher watcher;
    private FileInputStream in;
    private byte lastByte;
    private File currentFile;

    public LocalFSInputStream(FileSystemWatcher watcher) {
        this.watcher = watcher;
    }

    @Override
    public void setController(AbstractFeedDataFlowController controller) {
        super.setController(controller);
    }

    @Override
    public void setFeedLogManager(FeedLogManager logManager) throws HyracksDataException {
        super.setFeedLogManager(logManager);
        this.watcher.setFeedLogManager(logManager);
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        if (this.in != null) {
            try {
                this.closeFile();
            }
            catch (Exception e) {
                ioe = new IOException(e);
            }
        }
        try {
            this.watcher.close();
        }
        catch (Exception e) {
            if (ioe == null) {
                throw e;
            }
            ioe.addSuppressed(e);
            throw ioe;
        }
    }

    private void closeFile() throws IOException {
        if (this.in != null) {
            if (this.logManager != null) {
                this.logManager.endPartition(this.currentFile.getAbsolutePath());
            }
            try {
                this.in.close();
            }
            finally {
                this.in = null;
                this.currentFile = null;
            }
        }
    }

    private boolean advance() throws IOException {
        this.closeFile();
        this.currentFile = this.watcher.poll();
        if (this.currentFile == null) {
            if (this.controller != null) {
                this.controller.flush();
            }
            this.currentFile = this.watcher.take();
        }
        if (this.currentFile != null) {
            this.in = new FileInputStream(this.currentFile);
            if (this.notificationHandler != null) {
                this.notificationHandler.notifyNewSource();
            }
            return true;
        }
        return false;
    }

    @Override
    public int read() throws IOException {
        throw new HyracksDataException("read() is not supported with this stream. use read(byte[] b, int off, int len)");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null && !this.advance()) {
            return -1;
        }
        int result = this.in.read(b, off, len);
        while (result < 0 && this.advance()) {
            if (this.lastByte != 10 && this.lastByte != 10) {
                this.lastByte = (byte)10;
                b[off] = 10;
                return 1;
            }
            result = this.in.read(b, off, len);
        }
        if (result > 0) {
            this.lastByte = b[off + result - 1];
        }
        return result;
    }

    @Override
    public boolean stop() throws Exception {
        this.closeFile();
        this.watcher.close();
        return true;
    }

    @Override
    public boolean handleException(Throwable th) {
        if (this.in == null) {
            return false;
        }
        if (th instanceof HyracksDataException && ((HyracksDataException)th).getErrorCode() == 3021) {
            if (this.currentFile != null) {
                try {
                    this.logManager.logRecord(this.currentFile.getAbsolutePath(), "Corrupted input file");
                }
                catch (IOException e) {
                    LOGGER.warn((Object)"Filed to write to feed log file", (Throwable)e);
                }
                LOGGER.warn((Object)("Corrupted input file: " + this.currentFile.getAbsolutePath()));
            }
            try {
                this.advance();
                return true;
            }
            catch (Exception e) {
                LOGGER.warn((Object)"An exception was thrown while trying to skip a file", (Throwable)e);
            }
        }
        LOGGER.warn((Object)"Failed to recover from failure", th);
        return false;
    }
}

