/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IExternalIndexer;
import org.apache.asterix.external.api.IIndexingDatasource;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.input.record.reader.hdfs.EmptyRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class HDFSInputStream
extends AsterixInputStream
implements IIndexingDatasource {
    private RecordReader<Object, Text> reader;
    private Text value = null;
    private Object key = null;
    private int currentSplitIndex = 0;
    private boolean[] read;
    private InputFormat<?, Text> inputFormat;
    private InputSplit[] inputSplits;
    private String[] readSchedule;
    private String nodeName;
    private JobConf conf;
    private final IExternalIndexer indexer;
    private final List<ExternalFile> snapshot;
    private final FileSystem hdfs;
    private int pos = 0;

    public HDFSInputStream(boolean[] read, InputSplit[] inputSplits, String[] readSchedule, String nodeName, JobConf conf, Map<String, String> configuration, List<ExternalFile> snapshot, IExternalIndexer indexer) throws IOException, AsterixException {
        this.read = read;
        this.inputSplits = inputSplits;
        this.readSchedule = readSchedule;
        this.nodeName = nodeName;
        this.conf = conf;
        this.inputFormat = conf.getInputFormat();
        this.reader = new EmptyRecordReader<Object, Text>();
        this.snapshot = snapshot;
        this.hdfs = FileSystem.get((Configuration)conf);
        this.indexer = indexer;
        this.nextInputSplit();
        this.value = new Text();
        if (snapshot != null && this.currentSplitIndex < snapshot.size()) {
            indexer.reset(this);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.value.getLength() < this.pos) {
            if (!this.readMore()) {
                return -1;
            }
        } else if (this.value.getLength() == this.pos) {
            ++this.pos;
            return 10;
        }
        return this.value.getBytes()[this.pos++];
    }

    private int readRecord(byte[] buffer, int offset, int len) {
        int actualLength = this.value.getLength() + 1;
        if (actualLength - this.pos > len) {
            System.arraycopy(this.value.getBytes(), this.pos, buffer, offset, len);
            this.pos += len;
            return len;
        }
        int numBytes = this.value.getLength() - this.pos;
        System.arraycopy(this.value.getBytes(), this.pos, buffer, offset, numBytes);
        buffer[offset + numBytes] = 10;
        this.pos += numBytes;
        return ++numBytes;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.value.getLength() > this.pos) {
            return this.readRecord(buffer, offset, len);
        }
        if (!this.readMore()) {
            return -1;
        }
        return this.readRecord(buffer, offset, len);
    }

    private boolean readMore() throws IOException {
        try {
            this.pos = 0;
            return this.hasNext();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean stop() throws Exception {
        return false;
    }

    @Override
    public boolean handleException(Throwable th) {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private boolean hasNext() throws Exception {
        if (this.reader.next(this.key, (Object)this.value)) {
            return true;
        }
        while (this.nextInputSplit()) {
            if (!this.reader.next(this.key, (Object)this.value)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean nextInputSplit() throws IOException {
        while (this.currentSplitIndex < this.inputSplits.length) {
            block5: {
                block7: {
                    block8: {
                        block6: {
                            if (!this.readSchedule[this.currentSplitIndex].equals(this.nodeName)) break block5;
                            boolean[] blArray = this.read;
                            // MONITORENTER : this.read
                            if (this.read[this.currentSplitIndex]) break block6;
                            this.read[this.currentSplitIndex] = true;
                            // MONITOREXIT : blArray
                            if (this.snapshot == null) break block7;
                            break block8;
                        }
                        // MONITOREXIT : blArray
                        break block5;
                    }
                    String fileName = ((FileSplit)this.inputSplits[this.currentSplitIndex]).getPath().toUri().getPath();
                    FileStatus fileStatus = this.hdfs.getFileStatus(new Path(fileName));
                    if (fileStatus.getModificationTime() != this.snapshot.get(this.currentSplitIndex).getLastModefiedTime().getTime()) break block5;
                }
                this.reader.close();
                this.reader = this.getRecordReader(this.currentSplitIndex);
                return true;
            }
            ++this.currentSplitIndex;
        }
        return false;
    }

    private RecordReader<Object, Text> getRecordReader(int splitIndex) throws IOException {
        this.reader = this.inputFormat.getRecordReader(this.inputSplits[splitIndex], this.conf, Reporter.NULL);
        if (this.key == null) {
            this.key = this.reader.createKey();
            this.value = (Text)this.reader.createValue();
        }
        if (this.indexer != null) {
            try {
                this.indexer.reset(this);
            }
            catch (Exception e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        return this.reader;
    }

    @Override
    public IExternalIndexer getIndexer() {
        return this.indexer;
    }

    @Override
    public List<ExternalFile> getSnapshot() {
        return this.snapshot;
    }

    @Override
    public int getCurrentSplitIndex() {
        return this.currentSplitIndex;
    }

    @Override
    public RecordReader<?, ? extends Writable> getReader() {
        return this.reader;
    }
}

