/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.indexing;

import java.io.IOException;
import org.apache.asterix.external.api.IExternalIndexer;
import org.apache.asterix.external.api.IIndexingDatasource;
import org.apache.asterix.external.input.record.reader.hdfs.HDFSRecordReader;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;

public class RecordColumnarIndexer
implements IExternalIndexer {
    private static final long serialVersionUID = 1L;
    public static final int NUM_OF_FIELDS = 3;
    protected final AMutableInt32 fileNumber = new AMutableInt32(0);
    protected final AMutableInt64 offset = new AMutableInt64(0L);
    protected long nextOffset;
    protected final AMutableInt32 rowNumber = new AMutableInt32(0);
    protected RecordReader<?, Writable> recordReader;
    private ISerializerDeserializer<IAObject> intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    private ISerializerDeserializer<IAObject> longSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);

    @Override
    public void reset(IIndexingDatasource reader) throws HyracksDataException {
        try {
            HDFSRecordReader hdfsReader = (HDFSRecordReader)reader;
            this.fileNumber.setValue(hdfsReader.getSnapshot().get(hdfsReader.getCurrentSplitIndex()).getFileNumber());
            this.recordReader = hdfsReader.getReader();
            this.offset.setValue(this.recordReader.getPos());
            this.nextOffset = this.offset.getLongValue();
            this.rowNumber.setValue(0);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    @Override
    public void index(ArrayTupleBuilder tb) throws HyracksDataException {
        try {
            if (this.recordReader.getPos() != this.nextOffset) {
                this.offset.setValue(this.nextOffset);
                this.nextOffset = this.recordReader.getPos();
                this.rowNumber.setValue(0);
            }
            tb.addField(this.intSerde, (Object)this.fileNumber);
            tb.addField(this.longSerde, (Object)this.offset);
            tb.addField(this.intSerde, (Object)this.rowNumber);
            this.rowNumber.setValue(this.rowNumber.getIntegerValue() + 1);
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    @Override
    public int getNumberOfFields() {
        return 3;
    }
}

