/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.adapter.factory;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.external.api.ILookupReaderFactory;
import org.apache.asterix.external.api.ILookupRecordReader;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IRecordDataParserFactory;
import org.apache.asterix.external.dataset.adapter.LookupAdapter;
import org.apache.asterix.external.indexing.ExternalFileIndexAccessor;
import org.apache.asterix.external.indexing.RecordIdReader;
import org.apache.asterix.external.indexing.RecordIdReaderFactory;
import org.apache.asterix.external.provider.LookupReaderFactoryProvider;
import org.apache.asterix.external.provider.ParserFactoryProvider;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class LookupAdapterFactory<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IRecordDataParserFactory dataParserFactory;
    private ILookupReaderFactory readerFactory;
    private final ARecordType recordType;
    private final int[] ridFields;
    private Map<String, String> configuration;
    private final boolean retainInput;
    private final boolean retainMissing;
    private final IMissingWriterFactory isMissingWriterFactory;

    public LookupAdapterFactory(ARecordType recordType, int[] ridFields, boolean retainInput, boolean retainNull, IMissingWriterFactory iNullWriterFactory) {
        this.recordType = recordType;
        this.ridFields = ridFields;
        this.retainInput = retainInput;
        this.retainMissing = retainNull;
        this.isMissingWriterFactory = iNullWriterFactory;
    }

    public LookupAdapter<T> createAdapter(IHyracksTaskContext ctx, int partition, RecordDescriptor inRecDesc, ExternalFileIndexAccessor snapshotAccessor, IFrameWriter writer) throws HyracksDataException {
        try {
            IRecordDataParser dataParser = this.dataParserFactory.createRecordParser(ctx);
            ILookupRecordReader reader = this.readerFactory.createRecordReader(ctx, partition, snapshotAccessor);
            reader.configure(this.configuration);
            RecordIdReader ridReader = RecordIdReaderFactory.create(this.configuration, this.ridFields);
            return new LookupAdapter(dataParser, reader, inRecDesc, ridReader, this.retainInput, this.retainMissing, this.isMissingWriterFactory, ctx, writer);
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void configure(IServiceContext serviceContext, Map<String, String> configuration) throws HyracksDataException, AlgebricksException {
        this.configuration = configuration;
        IApplicationContext appCtx = (IApplicationContext)serviceContext.getApplicationContext();
        this.readerFactory = LookupReaderFactoryProvider.getLookupReaderFactory(serviceContext, configuration);
        this.dataParserFactory = (IRecordDataParserFactory)ParserFactoryProvider.getDataParserFactory(appCtx.getLibraryManager(), configuration);
        this.dataParserFactory.setRecordType(this.recordType);
        this.readerFactory.configure(serviceContext, configuration);
        this.dataParserFactory.configure(configuration);
    }
}

