/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeFrameTupleAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeFrameTupleAppender;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeTupleReference;

public class SearchResult {
    protected final ArrayList<ByteBuffer> buffers = new ArrayList();
    protected final IHyracksCommonContext ctx;
    protected final FixedSizeFrameTupleAppender appender;
    protected final FixedSizeFrameTupleAccessor accessor;
    protected final FixedSizeTupleReference tuple;
    protected final ITypeTraits[] typeTraits;
    protected final int invListElementSize;
    protected int currBufIdx;
    protected int numResults;

    public SearchResult(ITypeTraits[] invListFields, IHyracksCommonContext ctx) throws HyracksDataException {
        this.typeTraits = new ITypeTraits[invListFields.length + 1];
        int tmp = 0;
        for (int i = 0; i < invListFields.length; ++i) {
            this.typeTraits[i] = invListFields[i];
            tmp += invListFields[i].getFixedLength();
        }
        this.invListElementSize = tmp;
        this.typeTraits[invListFields.length] = IntegerPointable.TYPE_TRAITS;
        this.ctx = ctx;
        this.appender = new FixedSizeFrameTupleAppender(ctx.getInitialFrameSize(), this.typeTraits);
        this.accessor = new FixedSizeFrameTupleAccessor(ctx.getInitialFrameSize(), this.typeTraits);
        this.tuple = new FixedSizeTupleReference(this.typeTraits);
        this.buffers.add(ctx.allocateFrame());
    }

    public SearchResult(SearchResult other) throws HyracksDataException {
        this.ctx = other.ctx;
        this.appender = other.appender;
        this.accessor = other.accessor;
        this.tuple = other.tuple;
        this.typeTraits = other.typeTraits;
        this.invListElementSize = other.invListElementSize;
        this.buffers.add(this.ctx.allocateFrame());
    }

    public FixedSizeFrameTupleAccessor getAccessor() {
        return this.accessor;
    }

    public FixedSizeFrameTupleAppender getAppender() {
        return this.appender;
    }

    public FixedSizeTupleReference getTuple() {
        return this.tuple;
    }

    public ArrayList<ByteBuffer> getBuffers() {
        return this.buffers;
    }

    public void reset() {
        this.currBufIdx = 0;
        this.numResults = 0;
        this.appender.reset(this.buffers.get(0), true);
    }

    public void clear() {
        this.currBufIdx = 0;
        this.numResults = 0;
        for (ByteBuffer buffer : this.buffers) {
            this.appender.reset(buffer, true);
        }
    }

    public void append(ITupleReference invListElement, int count) throws HyracksDataException {
        ByteBuffer currentBuffer = this.buffers.get(this.currBufIdx);
        if (!this.appender.hasSpace()) {
            ++this.currBufIdx;
            if (this.currBufIdx >= this.buffers.size()) {
                this.buffers.add(this.ctx.allocateFrame());
            }
            currentBuffer = this.buffers.get(this.currBufIdx);
            this.appender.reset(currentBuffer, true);
        }
        if (!this.appender.append(invListElement.getFieldData(0), invListElement.getFieldStart(0), this.invListElementSize)) {
            throw new IllegalStateException();
        }
        if (!this.appender.append(count)) {
            throw new IllegalStateException();
        }
        this.appender.incrementTupleCount(1);
        ++this.numResults;
    }

    public int getCurrentBufferIndex() {
        return this.currBufIdx;
    }

    public ITypeTraits[] getTypeTraits() {
        return this.typeTraits;
    }

    public int getNumResults() {
        return this.numResults;
    }
}

