/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeFrameTupleAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.SearchResult;
import org.apache.hyracks.storage.common.MultiComparator;

public class InvertedListMerger {
    protected final MultiComparator invListCmp;
    protected SearchResult prevSearchResult;
    protected SearchResult newSearchResult;

    public InvertedListMerger(IHyracksCommonContext ctx, IInvertedIndex invIndex) throws HyracksDataException {
        this.invListCmp = MultiComparator.create((IBinaryComparatorFactory[])invIndex.getInvListCmpFactories());
        this.prevSearchResult = new SearchResult(invIndex.getInvListTypeTraits(), ctx);
        this.newSearchResult = new SearchResult(this.prevSearchResult);
    }

    public void merge(ArrayList<IInvertedListCursor> invListCursors, int occurrenceThreshold, int numPrefixLists, SearchResult searchResult) throws HyracksDataException {
        Collections.sort(invListCursors);
        int numInvLists = invListCursors.size();
        SearchResult result = null;
        for (int i = 0; i < numInvLists; ++i) {
            SearchResult swapTemp = this.prevSearchResult;
            this.prevSearchResult = this.newSearchResult;
            this.newSearchResult = swapTemp;
            this.newSearchResult.reset();
            result = i + 1 != numInvLists ? this.newSearchResult : searchResult;
            IInvertedListCursor invListCursor = invListCursors.get(i);
            invListCursor.pinPages();
            if (i < numPrefixLists) {
                this.mergePrefixList(invListCursor, this.prevSearchResult, result);
            } else {
                int numInvListElements = invListCursor.size();
                int currentNumResults = this.prevSearchResult.getNumResults();
                if ((double)currentNumResults * Math.log(numInvListElements) < (double)(currentNumResults + numInvListElements)) {
                    this.mergeSuffixListProbe(invListCursor, this.prevSearchResult, result, i, numInvLists, occurrenceThreshold);
                } else {
                    this.mergeSuffixListScan(invListCursor, this.prevSearchResult, result, i, numInvLists, occurrenceThreshold);
                }
            }
            invListCursor.unpinPages();
        }
    }

    protected void mergeSuffixListProbe(IInvertedListCursor invListCursor, SearchResult prevSearchResult, SearchResult newSearchResult, int invListIx, int numInvLists, int occurrenceThreshold) throws HyracksDataException {
        int prevBufIdx = 0;
        int maxPrevBufIdx = prevSearchResult.getCurrentBufferIndex();
        ByteBuffer prevCurrentBuffer = prevSearchResult.getBuffers().get(0);
        FixedSizeFrameTupleAccessor resultFrameTupleAcc = prevSearchResult.getAccessor();
        FixedSizeTupleReference resultTuple = prevSearchResult.getTuple();
        int resultTidx = 0;
        resultFrameTupleAcc.reset(prevCurrentBuffer);
        while (resultTidx < resultFrameTupleAcc.getTupleCount()) {
            resultTuple.reset(prevCurrentBuffer.array(), resultFrameTupleAcc.getTupleStartOffset(resultTidx));
            int count = IntegerPointable.getInteger((byte[])resultTuple.getFieldData(0), (int)resultTuple.getFieldStart(resultTuple.getFieldCount() - 1));
            if (invListCursor.containsKey(resultTuple, this.invListCmp)) {
                newSearchResult.append(resultTuple, ++count);
            } else if (count + numInvLists - invListIx > occurrenceThreshold) {
                newSearchResult.append(resultTuple, count);
            }
            if (++resultTidx < resultFrameTupleAcc.getTupleCount() || ++prevBufIdx > maxPrevBufIdx) continue;
            prevCurrentBuffer = prevSearchResult.getBuffers().get(prevBufIdx);
            resultFrameTupleAcc.reset(prevCurrentBuffer);
            resultTidx = 0;
        }
    }

    protected void mergeSuffixListScan(IInvertedListCursor invListCursor, SearchResult prevSearchResult, SearchResult newSearchResult, int invListIx, int numInvLists, int occurrenceThreshold) throws HyracksDataException {
        int prevBufIdx = 0;
        int maxPrevBufIdx = prevSearchResult.getCurrentBufferIndex();
        ByteBuffer prevCurrentBuffer = prevSearchResult.getBuffers().get(0);
        FixedSizeFrameTupleAccessor resultFrameTupleAcc = prevSearchResult.getAccessor();
        FixedSizeTupleReference resultTuple = prevSearchResult.getTuple();
        boolean advanceCursor = true;
        boolean advancePrevResult = false;
        int resultTidx = 0;
        resultFrameTupleAcc.reset(prevCurrentBuffer);
        int invListTidx = 0;
        int invListNumTuples = invListCursor.size();
        if (invListCursor.hasNext()) {
            invListCursor.next();
        }
        while (invListTidx < invListNumTuples && resultTidx < resultFrameTupleAcc.getTupleCount()) {
            int count;
            ITupleReference invListTuple = invListCursor.getTuple();
            resultTuple.reset(prevCurrentBuffer.array(), resultFrameTupleAcc.getTupleStartOffset(resultTidx));
            int cmp = this.invListCmp.compare(invListTuple, (ITupleReference)resultTuple);
            if (cmp == 0) {
                count = IntegerPointable.getInteger((byte[])resultTuple.getFieldData(0), (int)resultTuple.getFieldStart(resultTuple.getFieldCount() - 1)) + 1;
                newSearchResult.append(resultTuple, count);
                advanceCursor = true;
                advancePrevResult = true;
            } else if (cmp < 0) {
                advanceCursor = true;
                advancePrevResult = false;
            } else {
                count = IntegerPointable.getInteger((byte[])resultTuple.getFieldData(0), (int)resultTuple.getFieldStart(resultTuple.getFieldCount() - 1));
                if (count + numInvLists - invListIx > occurrenceThreshold) {
                    newSearchResult.append(resultTuple, count);
                }
                advanceCursor = false;
                advancePrevResult = true;
            }
            if (advancePrevResult && ++resultTidx >= resultFrameTupleAcc.getTupleCount() && ++prevBufIdx <= maxPrevBufIdx) {
                prevCurrentBuffer = prevSearchResult.getBuffers().get(prevBufIdx);
                resultFrameTupleAcc.reset(prevCurrentBuffer);
                resultTidx = 0;
            }
            if (!advanceCursor) continue;
            ++invListTidx;
            if (!invListCursor.hasNext()) continue;
            invListCursor.next();
        }
        while (resultTidx < resultFrameTupleAcc.getTupleCount()) {
            resultTuple.reset(prevCurrentBuffer.array(), resultFrameTupleAcc.getTupleStartOffset(resultTidx));
            int count = IntegerPointable.getInteger((byte[])resultTuple.getFieldData(0), (int)resultTuple.getFieldStart(resultTuple.getFieldCount() - 1));
            if (count + numInvLists - invListIx > occurrenceThreshold) {
                newSearchResult.append(resultTuple, count);
            }
            if (++resultTidx < resultFrameTupleAcc.getTupleCount() || ++prevBufIdx > maxPrevBufIdx) continue;
            prevCurrentBuffer = prevSearchResult.getBuffers().get(prevBufIdx);
            resultFrameTupleAcc.reset(prevCurrentBuffer);
            resultTidx = 0;
        }
    }

    protected void mergePrefixList(IInvertedListCursor invListCursor, SearchResult prevSearchResult, SearchResult newSearchResult) throws HyracksDataException {
        ITupleReference invListTuple;
        int prevBufIdx = 0;
        int maxPrevBufIdx = prevSearchResult.getCurrentBufferIndex();
        ByteBuffer prevCurrentBuffer = prevSearchResult.getBuffers().get(0);
        FixedSizeFrameTupleAccessor resultFrameTupleAcc = prevSearchResult.getAccessor();
        FixedSizeTupleReference resultTuple = prevSearchResult.getTuple();
        boolean advanceCursor = true;
        boolean advancePrevResult = false;
        int resultTidx = 0;
        resultFrameTupleAcc.reset(prevCurrentBuffer);
        int invListTidx = 0;
        int invListNumTuples = invListCursor.size();
        if (invListCursor.hasNext()) {
            invListCursor.next();
        }
        while (invListTidx < invListNumTuples && resultTidx < resultFrameTupleAcc.getTupleCount()) {
            int count;
            invListTuple = invListCursor.getTuple();
            resultTuple.reset(prevCurrentBuffer.array(), resultFrameTupleAcc.getTupleStartOffset(resultTidx));
            int cmp = this.invListCmp.compare(invListTuple, (ITupleReference)resultTuple);
            if (cmp == 0) {
                count = IntegerPointable.getInteger((byte[])resultTuple.getFieldData(0), (int)resultTuple.getFieldStart(resultTuple.getFieldCount() - 1)) + 1;
                newSearchResult.append(resultTuple, count);
                advanceCursor = true;
                advancePrevResult = true;
            } else if (cmp < 0) {
                count = 1;
                newSearchResult.append(invListTuple, count);
                advanceCursor = true;
                advancePrevResult = false;
            } else {
                count = IntegerPointable.getInteger((byte[])resultTuple.getFieldData(0), (int)resultTuple.getFieldStart(resultTuple.getFieldCount() - 1));
                newSearchResult.append(resultTuple, count);
                advanceCursor = false;
                advancePrevResult = true;
            }
            if (advancePrevResult && ++resultTidx >= resultFrameTupleAcc.getTupleCount() && ++prevBufIdx <= maxPrevBufIdx) {
                prevCurrentBuffer = prevSearchResult.getBuffers().get(prevBufIdx);
                resultFrameTupleAcc.reset(prevCurrentBuffer);
                resultTidx = 0;
            }
            if (!advanceCursor) continue;
            ++invListTidx;
            if (!invListCursor.hasNext()) continue;
            invListCursor.next();
        }
        while (invListTidx < invListNumTuples) {
            invListTuple = invListCursor.getTuple();
            newSearchResult.append(invListTuple, 1);
            ++invListTidx;
            if (!invListCursor.hasNext()) continue;
            invListCursor.next();
        }
        while (resultTidx < resultFrameTupleAcc.getTupleCount()) {
            resultTuple.reset(prevCurrentBuffer.array(), resultFrameTupleAcc.getTupleStartOffset(resultTidx));
            int count = IntegerPointable.getInteger((byte[])resultTuple.getFieldData(0), (int)resultTuple.getFieldStart(resultTuple.getFieldCount() - 1));
            newSearchResult.append(resultTuple, count);
            if (++resultTidx < resultFrameTupleAcc.getTupleCount() || ++prevBufIdx > maxPrevBufIdx) continue;
            prevCurrentBuffer = prevSearchResult.getBuffers().get(prevBufIdx);
            resultFrameTupleAcc.reset(prevCurrentBuffer);
            resultTidx = 0;
        }
    }

    public SearchResult createSearchResult() throws HyracksDataException {
        return new SearchResult(this.prevSearchResult);
    }

    public void reset() {
        this.prevSearchResult.clear();
        this.newSearchResult.clear();
    }
}

