/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppenderAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.UTF8StringSerializerDeserializer;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInPlaceInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IObjectFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeFrameTupleAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedListCursorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedListMerger;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.SearchResult;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.DelimitedUTF8StringBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IToken;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.TokenizerInfo;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.ObjectCache;
import org.apache.hyracks.storage.common.MultiComparator;

public abstract class AbstractTOccurrenceSearcher
implements IInvertedIndexSearcher {
    protected static final RecordDescriptor QUERY_TOKEN_REC_DESC = new RecordDescriptor(new ISerializerDeserializer[]{new UTF8StringSerializerDeserializer()});
    protected final int OBJECT_CACHE_INIT_SIZE = 10;
    protected final int OBJECT_CACHE_EXPAND_SIZE = 10;
    protected final IHyracksCommonContext ctx;
    protected final InvertedListMerger invListMerger;
    protected final SearchResult searchResult;
    protected final IInPlaceInvertedIndex invIndex;
    protected final MultiComparator invListCmp;
    protected final ArrayTupleBuilder queryTokenBuilder = new ArrayTupleBuilder(QUERY_TOKEN_REC_DESC.getFieldCount());
    protected final IFrame queryTokenFrame;
    protected final FrameTupleAppenderAccessor queryTokenAppender;
    protected final FrameTupleReference searchKey = new FrameTupleReference();
    protected int occurrenceThreshold;
    protected final IObjectFactory<IInvertedListCursor> invListCursorFactory;
    protected final ObjectCache<IInvertedListCursor> invListCursorCache;

    public AbstractTOccurrenceSearcher(IHyracksCommonContext ctx, IInPlaceInvertedIndex invIndex) throws HyracksDataException {
        this.ctx = ctx;
        this.invListMerger = new InvertedListMerger(ctx, invIndex);
        this.searchResult = new SearchResult(invIndex.getInvListTypeTraits(), ctx);
        this.invIndex = invIndex;
        this.invListCmp = MultiComparator.create((IBinaryComparatorFactory[])invIndex.getInvListCmpFactories());
        this.invListCursorFactory = new InvertedListCursorFactory(invIndex);
        this.invListCursorCache = new ObjectCache<IInvertedListCursor>(this.invListCursorFactory, 10, 10);
        this.queryTokenFrame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.queryTokenAppender = new FrameTupleAppenderAccessor(QUERY_TOKEN_REC_DESC);
        this.queryTokenAppender.reset(this.queryTokenFrame, true);
    }

    @Override
    public void reset() {
        this.searchResult.clear();
        this.invListMerger.reset();
    }

    protected void tokenizeQuery(InvertedIndexSearchPredicate searchPred) throws HyracksDataException {
        ITupleReference queryTuple = searchPred.getQueryTuple();
        int queryFieldIndex = searchPred.getQueryFieldIndex();
        IBinaryTokenizer queryTokenizer = searchPred.getQueryTokenizer();
        boolean isFullTextSearchQuery = searchPred.getIsFullTextSearchQuery();
        TokenizerInfo.TokenizerType queryTokenizerType = queryTokenizer.getTokenizerType();
        int tokenCountInOneField = 0;
        this.queryTokenAppender.reset(this.queryTokenFrame, true);
        queryTokenizer.reset(queryTuple.getFieldData(queryFieldIndex), queryTuple.getFieldStart(queryFieldIndex), queryTuple.getFieldLength(queryFieldIndex));
        while (queryTokenizer.hasNext()) {
            queryTokenizer.next();
            this.queryTokenBuilder.reset();
            ++tokenCountInOneField;
            try {
                IToken token = queryTokenizer.getToken();
                if (isFullTextSearchQuery) {
                    if (queryTokenizerType == TokenizerInfo.TokenizerType.STRING && tokenCountInOneField > 1) {
                        throw HyracksDataException.create((int)5, (Serializable[])new Serializable[0]);
                    }
                    if (queryTokenizerType == TokenizerInfo.TokenizerType.LIST) {
                        for (int j = 1; j < token.getTokenLength(); ++j) {
                            if (!DelimitedUTF8StringBinaryTokenizer.isSeparator((char)token.getData()[token.getStartOffset() + j])) continue;
                            throw HyracksDataException.create((int)5, (Serializable[])new Serializable[0]);
                        }
                    }
                }
                token.serializeToken(this.queryTokenBuilder.getFieldData());
                this.queryTokenBuilder.addFieldEndOffset();
                this.queryTokenAppender.append(this.queryTokenBuilder.getFieldEndOffsets(), this.queryTokenBuilder.getByteArray(), 0, this.queryTokenBuilder.getSize());
            }
            catch (IOException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
    }

    @Override
    public IFrameTupleAccessor createResultFrameTupleAccessor() {
        return new FixedSizeFrameTupleAccessor(this.ctx.getInitialFrameSize(), this.searchResult.getTypeTraits());
    }

    @Override
    public ITupleReference createResultFrameTupleReference() {
        return new FixedSizeTupleReference(this.searchResult.getTypeTraits());
    }

    @Override
    public List<ByteBuffer> getResultBuffers() {
        return this.searchResult.getBuffers();
    }

    @Override
    public int getNumValidResultBuffers() {
        return this.searchResult.getCurrentBufferIndex() + 1;
    }

    public int getOccurrenceThreshold() {
        return this.occurrenceThreshold;
    }

    public void printNewResults(int maxResultBufIdx, List<ByteBuffer> buffer) {
        StringBuffer strBuffer = new StringBuffer();
        FixedSizeFrameTupleAccessor resultFrameTupleAcc = this.searchResult.getAccessor();
        for (int i = 0; i <= maxResultBufIdx; ++i) {
            ByteBuffer testBuf = buffer.get(i);
            resultFrameTupleAcc.reset(testBuf);
            for (int j = 0; j < resultFrameTupleAcc.getTupleCount(); ++j) {
                strBuffer.append(IntegerPointable.getInteger((byte[])resultFrameTupleAcc.getBuffer().array(), (int)resultFrameTupleAcc.getFieldStartOffset(j, 0)) + ",");
                strBuffer.append(IntegerPointable.getInteger((byte[])resultFrameTupleAcc.getBuffer().array(), (int)resultFrameTupleAcc.getFieldStartOffset(j, 1)) + " ");
            }
        }
        System.out.println(strBuffer.toString());
    }
}

