/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.tuples.ConcatenatingTupleReference;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInPlaceInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndex;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class OnDiskInvertedIndexRangeSearchCursor
implements IIndexCursor {
    private final BTree btree;
    private final IIndexAccessor btreeAccessor;
    private final IInPlaceInvertedIndex invIndex;
    private final IIndexOperationContext opCtx;
    private final IInvertedListCursor invListCursor;
    private boolean unpinNeeded;
    private final IIndexCursor btreeCursor;
    private RangePredicate btreePred;
    private final PermutingTupleReference tokenTuple;
    private ConcatenatingTupleReference concatTuple;

    public OnDiskInvertedIndexRangeSearchCursor(IInPlaceInvertedIndex invIndex, IIndexOperationContext opCtx) {
        this.btree = ((OnDiskInvertedIndex)invIndex).getBTree();
        this.btreeAccessor = this.btree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        this.invIndex = invIndex;
        this.opCtx = opCtx;
        int[] fieldPermutation = new int[invIndex.getTokenTypeTraits().length];
        for (int i = 0; i < invIndex.getTokenTypeTraits().length; ++i) {
            fieldPermutation[i] = i;
        }
        this.tokenTuple = new PermutingTupleReference(fieldPermutation);
        this.btreeCursor = this.btreeAccessor.createSearchCursor(false);
        this.concatTuple = new ConcatenatingTupleReference(2);
        this.invListCursor = invIndex.createInvertedListCursor();
        this.unpinNeeded = false;
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        this.btreePred = (RangePredicate)searchPred;
        this.btreeAccessor.search(this.btreeCursor, (ISearchPredicate)this.btreePred);
        this.invListCursor.pinPages();
        this.unpinNeeded = true;
    }

    public boolean hasNext() throws HyracksDataException {
        if (this.invListCursor.hasNext()) {
            return true;
        }
        if (this.unpinNeeded) {
            this.invListCursor.unpinPages();
            this.unpinNeeded = false;
        }
        if (!this.btreeCursor.hasNext()) {
            return false;
        }
        this.btreeCursor.next();
        this.tokenTuple.reset(this.btreeCursor.getTuple());
        this.invIndex.openInvertedListCursor(this.invListCursor, (ITupleReference)this.tokenTuple, this.opCtx);
        this.invListCursor.pinPages();
        this.invListCursor.hasNext();
        this.unpinNeeded = true;
        this.concatTuple.reset();
        this.concatTuple.addTuple((ITupleReference)this.tokenTuple);
        return true;
    }

    public void next() throws HyracksDataException {
        this.invListCursor.next();
        if (this.concatTuple.hasMaxTuples()) {
            this.concatTuple.removeLastTuple();
        }
        this.concatTuple.addTuple(this.invListCursor.getTuple());
    }

    public void close() throws HyracksDataException {
        if (this.unpinNeeded) {
            this.invListCursor.unpinPages();
            this.unpinNeeded = false;
        }
        this.btreeCursor.close();
    }

    public void reset() throws HyracksDataException {
        if (this.unpinNeeded) {
            this.invListCursor.unpinPages();
            this.unpinNeeded = false;
        }
        this.btreeCursor.close();
    }

    public ITupleReference getTuple() {
        return this.concatTuple;
    }

    public ITupleReference getFilterMinTuple() {
        return null;
    }

    public ITupleReference getFilterMaxTuple() {
        return null;
    }
}

