/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;

public class FixedSizeFrameTupleAccessor
implements IFrameTupleAccessor {
    private final int frameSize;
    private ByteBuffer buffer;
    private final ITypeTraits[] fields;
    private final int[] fieldStartOffsets;
    private final int tupleSize;

    public FixedSizeFrameTupleAccessor(int frameSize, ITypeTraits[] fields) {
        this.frameSize = frameSize;
        this.fields = fields;
        this.fieldStartOffsets = new int[fields.length];
        this.fieldStartOffsets[0] = 0;
        for (int i = 1; i < fields.length; ++i) {
            this.fieldStartOffsets[i] = this.fieldStartOffsets[i - 1] + fields[i - 1].getFixedLength();
        }
        int tmp = 0;
        for (int i = 0; i < fields.length; ++i) {
            tmp += fields[i].getFixedLength();
        }
        this.tupleSize = tmp;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public int getFieldEndOffset(int tupleIndex, int fIdx) {
        return this.getTupleStartOffset(tupleIndex) + this.fieldStartOffsets[fIdx] + this.fields[fIdx].getFixedLength();
    }

    public int getFieldLength(int tupleIndex, int fIdx) {
        return this.fields[fIdx].getFixedLength();
    }

    public int getTupleLength(int tupleIndex) {
        return this.getTupleEndOffset(tupleIndex) - this.getTupleStartOffset(tupleIndex);
    }

    public int getFieldSlotsLength() {
        return 0;
    }

    public int getFieldStartOffset(int tupleIndex, int fIdx) {
        return tupleIndex * this.tupleSize + this.fieldStartOffsets[fIdx];
    }

    public int getTupleCount() {
        return this.buffer.getInt(FrameHelper.getTupleCountOffset((int)this.frameSize));
    }

    public int getTupleEndOffset(int tupleIndex) {
        return this.getFieldEndOffset(tupleIndex, this.fields.length - 1);
    }

    public int getTupleStartOffset(int tupleIndex) {
        return tupleIndex * this.tupleSize;
    }

    public int getAbsoluteFieldStartOffset(int tupleIndex, int fIdx) {
        return this.getTupleStartOffset(tupleIndex) + this.getFieldSlotsLength() + this.getFieldStartOffset(tupleIndex, fIdx);
    }

    public void reset(ByteBuffer buffer) {
        this.buffer = buffer;
    }
}

