/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.inmemory;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexTokenizingTupleIterator;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.MultiComparator;

public class InMemoryInvertedIndexOpContext
implements IIndexOperationContext {
    protected final BTree btree;
    protected final IBinaryComparatorFactory[] tokenCmpFactories;
    private IndexOperation op;
    private RangePredicate btreePred;
    private BTree.BTreeAccessor btreeAccessor;
    private MultiComparator btreeCmp;
    private MultiComparator tokenFieldsCmp;
    private final IBinaryTokenizerFactory tokenizerFactory;
    private InvertedIndexTokenizingTupleIterator tupleIter;

    InMemoryInvertedIndexOpContext(BTree btree, IBinaryComparatorFactory[] tokenCmpFactories, IBinaryTokenizerFactory tokenizerFactory) {
        this.btree = btree;
        this.tokenCmpFactories = tokenCmpFactories;
        this.tokenizerFactory = tokenizerFactory;
    }

    public void setOperation(IndexOperation newOp) {
        switch (newOp) {
            case INSERT: 
            case DELETE: {
                if (this.getTupleIter() != null) break;
                this.setTokenizingTupleIterator();
                break;
            }
            case SEARCH: {
                if (this.getBtreePred() != null) break;
                this.btreePred = new RangePredicate(null, null, true, true, null, null);
                this.btreeAccessor = (BTree.BTreeAccessor)this.btree.createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
                this.btreeCmp = MultiComparator.create((IBinaryComparatorFactory[])this.btree.getComparatorFactories());
                this.tokenFieldsCmp = MultiComparator.create((IBinaryComparatorFactory[])this.tokenCmpFactories);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation " + newOp);
            }
        }
        this.op = newOp;
    }

    public void reset() {
        this.op = null;
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    protected void setTokenizingTupleIterator() {
        IBinaryTokenizer tokenizer = this.getTokenizerFactory().createTokenizer();
        this.tupleIter = new InvertedIndexTokenizingTupleIterator(this.tokenCmpFactories.length, this.btree.getFieldCount() - this.tokenCmpFactories.length, tokenizer);
    }

    public InvertedIndexTokenizingTupleIterator getTupleIter() {
        return this.tupleIter;
    }

    public BTree.BTreeAccessor getBtreeAccessor() {
        return this.btreeAccessor;
    }

    public RangePredicate getBtreePred() {
        return this.btreePred;
    }

    public MultiComparator getTokenFieldsCmp() {
        return this.tokenFieldsCmp;
    }

    public MultiComparator getBtreeCmp() {
        return this.btreeCmp;
    }

    public IBinaryTokenizerFactory getTokenizerFactory() {
        return this.tokenizerFactory;
    }

    public void setTupleIter(InvertedIndexTokenizingTupleIterator tupleIter) {
        this.tupleIter = tupleIter;
    }
}

