/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.BloomFilterAwareBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexSearchCursorInitialState;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class LSMInvertedIndexSearchCursor
implements IIndexCursor {
    private IIndexAccessor currentAccessor;
    private IIndexCursor currentCursor;
    private int accessorIndex = -1;
    private boolean tupleConsumed = true;
    private ILSMHarness harness;
    private List<IIndexAccessor> indexAccessors;
    private ISearchPredicate searchPred;
    private ISearchOperationCallback searchCallback;
    private IIndexCursor[] deletedKeysBTreeCursors;
    private List<IIndexAccessor> deletedKeysBTreeAccessors;
    private RangePredicate keySearchPred;
    private ILSMIndexOperationContext opCtx;
    private List<ILSMComponent> operationalComponents;
    private ITupleReference currentTuple = null;
    private boolean resultOfSearchCallBackProceed = false;

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMInvertedIndexSearchCursorInitialState lsmInitState = (LSMInvertedIndexSearchCursorInitialState)initialState;
        this.harness = lsmInitState.getLSMHarness();
        this.operationalComponents = lsmInitState.getOperationalComponents();
        this.indexAccessors = lsmInitState.getIndexAccessors();
        this.opCtx = lsmInitState.getOpContext();
        this.accessorIndex = 0;
        this.searchPred = searchPred;
        this.searchCallback = lsmInitState.getSearchOperationCallback();
        this.deletedKeysBTreeAccessors = lsmInitState.getDeletedKeysBTreeAccessors();
        this.deletedKeysBTreeCursors = new IIndexCursor[this.deletedKeysBTreeAccessors.size()];
        for (int i = 0; i < this.operationalComponents.size(); ++i) {
            ILSMComponent component = this.operationalComponents.get(i);
            this.deletedKeysBTreeCursors[i] = component.getType() == ILSMComponent.LSMComponentType.MEMORY ? this.deletedKeysBTreeAccessors.get(i).createSearchCursor(false) : new BloomFilterAwareBTreePointSearchCursor((IBTreeLeafFrame)lsmInitState.getgetDeletedKeysBTreeLeafFrameFactory().createFrame(), false, ((LSMInvertedIndexDiskComponent)this.operationalComponents.get(i)).getBloomFilter());
        }
        MultiComparator keyCmp = lsmInitState.getKeyComparator();
        this.keySearchPred = new RangePredicate(null, null, true, true, keyCmp, keyCmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDeleted(ITupleReference key) throws HyracksDataException {
        this.keySearchPred.setLowKey(key, true);
        this.keySearchPred.setHighKey(key, true);
        for (int i = 0; i < this.accessorIndex; ++i) {
            this.deletedKeysBTreeCursors[i].reset();
            try {
                this.deletedKeysBTreeAccessors.get(i).search(this.deletedKeysBTreeCursors[i], (ISearchPredicate)this.keySearchPred);
                if (!this.deletedKeysBTreeCursors[i].hasNext()) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                this.deletedKeysBTreeCursors[i].close();
            }
        }
        return false;
    }

    private boolean nextValidTuple() throws HyracksDataException {
        while (this.currentCursor.hasNext()) {
            this.currentCursor.next();
            this.currentTuple = this.currentCursor.getTuple();
            this.resultOfSearchCallBackProceed = this.searchCallback.proceed(this.currentTuple);
            if (!this.resultOfSearchCallBackProceed) {
                this.searchCallback.reconcile(this.currentTuple);
            }
            if (!this.isDeleted(this.currentTuple)) {
                this.tupleConsumed = false;
                return true;
            }
            if (this.resultOfSearchCallBackProceed) continue;
            this.searchCallback.cancel(this.currentTuple);
        }
        return false;
    }

    public boolean hasNext() throws HyracksDataException {
        if (!this.tupleConsumed) {
            return true;
        }
        if (this.currentCursor != null) {
            if (this.nextValidTuple()) {
                return true;
            }
            this.currentCursor.close();
            ++this.accessorIndex;
        }
        while (this.accessorIndex < this.indexAccessors.size()) {
            this.currentAccessor = this.indexAccessors.get(this.accessorIndex);
            this.currentCursor = this.currentAccessor.createSearchCursor(false);
            this.currentAccessor.search(this.currentCursor, this.searchPred);
            if (this.nextValidTuple()) {
                return true;
            }
            this.currentCursor.close();
            ++this.accessorIndex;
        }
        return false;
    }

    public void next() throws HyracksDataException {
        this.tupleConsumed = true;
    }

    public void close() throws HyracksDataException {
        this.reset();
    }

    public void reset() throws HyracksDataException {
        try {
            if (this.currentCursor != null) {
                this.currentCursor.close();
                this.currentCursor = null;
            }
            this.accessorIndex = 0;
        }
        finally {
            if (this.harness != null) {
                this.harness.endSearch(this.opCtx);
            }
        }
    }

    public ITupleReference getTuple() {
        return this.currentCursor.getTuple();
    }

    public ITupleReference getFilterMinTuple() {
        ILSMComponentFilter filter = this.getComponentFilter();
        return filter == null ? null : filter.getMinTuple();
    }

    public ITupleReference getFilterMaxTuple() {
        ILSMComponentFilter filter = this.getComponentFilter();
        return filter == null ? null : filter.getMaxTuple();
    }

    private ILSMComponentFilter getComponentFilter() {
        if (this.accessorIndex < 0) {
            return null;
        }
        return this.operationalComponents.get(this.accessorIndex).getLSMComponentFilter();
    }
}

