/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMemoryComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.inmemory.InMemoryInvertedIndex;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;

public class LSMInvertedIndexOpContext
extends AbstractLSMIndexOperationContext {
    private static final int NUM_DOCUMENT_FIELDS = 1;
    private PermutingTupleReference keysOnlyTuple;
    private IInvertedIndexAccessor[] mutableInvIndexAccessors;
    private IIndexAccessor[] deletedKeysBTreeAccessors;
    private IInvertedIndexAccessor currentMutableInvIndexAccessors;
    private IIndexAccessor currentDeletedKeysBTreeAccessors;

    public LSMInvertedIndexOpContext(List<ILSMMemoryComponent> mutableComponents, IModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback, int[] invertedIndexFields, int[] filterFields, IBinaryComparatorFactory[] filterComparatorFactories) throws HyracksDataException {
        super(invertedIndexFields, filterFields, filterComparatorFactories, searchCallback, modificationCallback);
        this.mutableInvIndexAccessors = new IInvertedIndexAccessor[mutableComponents.size()];
        this.deletedKeysBTreeAccessors = new IIndexAccessor[mutableComponents.size()];
        for (int i = 0; i < mutableComponents.size(); ++i) {
            LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)mutableComponents.get(i);
            this.mutableInvIndexAccessors[i] = this.allFields != null ? (IInvertedIndexAccessor)((InMemoryInvertedIndex)mutableComponent.getInvIndex()).createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE, this.allFields) : (IInvertedIndexAccessor)mutableComponent.getInvIndex().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.deletedKeysBTreeAccessors[i] = mutableComponent.getDeletedKeysBTree().createAccessor((IModificationOperationCallback)NoOpOperationCallback.INSTANCE, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
        }
        LSMInvertedIndexMemoryComponent c = (LSMInvertedIndexMemoryComponent)mutableComponents.get(0);
        int numKeyFields = c.getInvIndex().getInvListTypeTraits().length;
        int[] keyFieldPermutation = new int[numKeyFields];
        for (int i = 0; i < numKeyFields; ++i) {
            keyFieldPermutation[i] = 1 + i;
        }
        this.keysOnlyTuple = new PermutingTupleReference(keyFieldPermutation);
    }

    public void setCurrentMutableComponentId(int currentMutableComponentId) {
        this.currentMutableInvIndexAccessors = this.mutableInvIndexAccessors[currentMutableComponentId];
        this.currentDeletedKeysBTreeAccessors = this.deletedKeysBTreeAccessors[currentMutableComponentId];
    }

    public IInvertedIndexAccessor getCurrentMutableInvIndexAccessors() {
        return this.currentMutableInvIndexAccessors;
    }

    public PermutingTupleReference getKeysOnlyTuple() {
        return this.keysOnlyTuple;
    }

    public IIndexAccessor getCurrentDeletedKeysBTreeAccessors() {
        return this.currentDeletedKeysBTreeAccessors;
    }
}

