/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilterFactory;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexFactory;

public class LSMInvertedIndexDiskComponentFactory
implements ILSMDiskComponentFactory {
    private final OnDiskInvertedIndexFactory diskInvIndexFactory;
    private final TreeIndexFactory<BTree> btreeFactory;
    private final BloomFilterFactory bloomFilterFactory;
    private final IComponentFilterHelper filterHelper;

    public LSMInvertedIndexDiskComponentFactory(OnDiskInvertedIndexFactory diskInvIndexFactory, TreeIndexFactory<BTree> btreeFactory, BloomFilterFactory bloomFilterFactory, IComponentFilterHelper filterHelper) {
        this.diskInvIndexFactory = diskInvIndexFactory;
        this.btreeFactory = btreeFactory;
        this.bloomFilterFactory = bloomFilterFactory;
        this.filterHelper = filterHelper;
    }

    public LSMInvertedIndexDiskComponent createComponent(LSMComponentFileReferences cfr) throws HyracksDataException {
        return new LSMInvertedIndexDiskComponent(this.diskInvIndexFactory.createIndexInstance(cfr.getInsertIndexFileReference()), (BTree)this.btreeFactory.createIndexInstance(cfr.getDeleteIndexFileReference()), this.bloomFilterFactory.createBloomFiltertInstance(cfr.getBloomFilterFileReference()), this.filterHelper == null ? null : this.filterHelper.createFilter());
    }
}

