/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.bloomfilter.impls.BloomFilter;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInPlaceInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndex;

public class LSMInvertedIndexDiskComponent
extends AbstractLSMDiskComponent {
    private final IInPlaceInvertedIndex invIndex;
    private final BTree deletedKeysBTree;
    private final BloomFilter bloomFilter;

    public LSMInvertedIndexDiskComponent(IInPlaceInvertedIndex invIndex, BTree deletedKeysBTree, BloomFilter bloomFilter, ILSMComponentFilter filter) throws HyracksDataException {
        super((IMetadataPageManager)deletedKeysBTree.getPageManager(), filter);
        this.invIndex = invIndex;
        this.deletedKeysBTree = deletedKeysBTree;
        this.bloomFilter = bloomFilter;
    }

    public void destroy() throws HyracksDataException {
        this.invIndex.deactivate();
        this.invIndex.destroy();
        this.deletedKeysBTree.deactivate();
        this.deletedKeysBTree.destroy();
        this.bloomFilter.deactivate();
        this.bloomFilter.destroy();
    }

    public IInPlaceInvertedIndex getInvIndex() {
        return this.invIndex;
    }

    public BTree getDeletedKeysBTree() {
        return this.deletedKeysBTree;
    }

    public BloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public long getComponentSize() {
        return ((OnDiskInvertedIndex)this.invIndex).getInvListsFile().getFile().length() + ((OnDiskInvertedIndex)this.invIndex).getBTree().getFileReference().getFile().length() + this.deletedKeysBTree.getFileReference().getFile().length() + this.bloomFilter.getFileReference().getFile().length();
    }

    public int getFileReferenceCount() {
        return this.deletedKeysBTree.getBufferCache().getFileReferenceCount(this.deletedKeysBTree.getFileId());
    }
}

