/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.rewriter.base;

import java.util.Collection;
import java.util.logging.Level;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.AlgebricksAppendable;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.LogicalOperatorPrettyPrintVisitor;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.PlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public abstract class AbstractRuleController {
    protected IOptimizationContext context;

    public void setContext(IOptimizationContext context) {
        this.context = context;
    }

    public abstract boolean rewriteWithRuleCollection(Mutable<ILogicalOperator> var1, Collection<IAlgebraicRewriteRule> var2) throws AlgebricksException;

    protected boolean rewriteOperatorRef(Mutable<ILogicalOperator> opRef, IAlgebraicRewriteRule rule) throws AlgebricksException {
        return this.rewriteOperatorRef(opRef, rule, true, false);
    }

    private String getPlanString(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isLoggable(Level.FINE) && this.context != null) {
            LogicalOperatorPrettyPrintVisitor pvisitor = this.context.getPrettyPrintVisitor();
            pvisitor.reset(new AlgebricksAppendable());
            PlanPrettyPrinter.printOperator((AbstractLogicalOperator)opRef.getValue(), pvisitor, 0);
            return pvisitor.get().toString();
        }
        return null;
    }

    private void printRuleApplication(IAlgebraicRewriteRule rule, String beforePlan, String afterPlan) throws AlgebricksException {
        if (AlgebricksConfig.ALGEBRICKS_LOGGER.isLoggable(Level.FINE)) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.fine(">>>> Rule " + rule.getClass() + " fired.\n");
            AlgebricksConfig.ALGEBRICKS_LOGGER.fine(">>>> Before plan\n" + beforePlan + "\n");
            AlgebricksConfig.ALGEBRICKS_LOGGER.fine(">>>> After plan\n" + afterPlan + "\n");
        }
    }

    protected boolean rewriteOperatorRef(Mutable<ILogicalOperator> opRef, IAlgebraicRewriteRule rule, boolean enterNestedPlans, boolean fullDFS) throws AlgebricksException {
        String preBeforePlan = this.getPlanString(opRef);
        if (rule.rewritePre(opRef, this.context)) {
            String preAfterPlan = this.getPlanString(opRef);
            this.printRuleApplication(rule, preBeforePlan, preAfterPlan);
            return true;
        }
        boolean rewritten = false;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        for (Mutable<ILogicalOperator> mutable : op.getInputs()) {
            if (!this.rewriteOperatorRef(mutable, rule, enterNestedPlans, fullDFS)) continue;
            rewritten = true;
            if (fullDFS) continue;
            break;
        }
        if (op.hasNestedPlans() && enterNestedPlans) {
            AbstractOperatorWithNestedPlans o2 = (AbstractOperatorWithNestedPlans)op;
            for (ILogicalPlan p : o2.getNestedPlans()) {
                for (Mutable<ILogicalOperator> r : p.getRoots()) {
                    if (!this.rewriteOperatorRef(r, rule, enterNestedPlans, fullDFS)) continue;
                    rewritten = true;
                    if (fullDFS) continue;
                    break;
                }
                if (!rewritten || fullDFS) continue;
                break;
            }
        }
        String postBeforePlan = this.getPlanString(opRef);
        if (rule.rewritePost(opRef, this.context)) {
            String string = this.getPlanString(opRef);
            this.printRuleApplication(rule, postBeforePlan, string);
            return true;
        }
        return rewritten;
    }
}

