/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractHashJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.JoinMultiComparatorFactory;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalGroupingProperty;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFamily;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluatorFactoryProvider;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.join.HybridHashJoinOperatorDescriptor;
import org.apache.hyracks.dataflow.std.join.OptimizedHybridHashJoinOperatorDescriptor;

public class HybridHashJoinPOperator
extends AbstractHashJoinPOperator {
    private final int memSizeInFrames;
    private final int maxInputBuildSizeInFrames;
    private final int aveRecordsPerFrame;
    private final double fudgeFactor;
    private static final Logger LOGGER = Logger.getLogger(HybridHashJoinPOperator.class.getName());

    public HybridHashJoinPOperator(AbstractBinaryJoinOperator.JoinKind kind, AbstractJoinPOperator.JoinPartitioningType partitioningType, List<LogicalVariable> sideLeftOfEqualities, List<LogicalVariable> sideRightOfEqualities, int memSizeInFrames, int maxInputSizeInFrames, int aveRecordsPerFrame, double fudgeFactor) {
        super(kind, partitioningType, sideLeftOfEqualities, sideRightOfEqualities);
        this.memSizeInFrames = memSizeInFrames;
        this.maxInputBuildSizeInFrames = maxInputSizeInFrames;
        this.aveRecordsPerFrame = aveRecordsPerFrame;
        this.fudgeFactor = fudgeFactor;
        LOGGER.fine("HybridHashJoinPOperator constructed with: JoinKind=" + (Object)((Object)kind) + ", JoinPartitioningType=" + (Object)((Object)partitioningType) + ", List<LogicalVariable>=" + sideLeftOfEqualities + ", List<LogicalVariable>=" + sideRightOfEqualities + ", int memSizeInFrames=" + memSizeInFrames + ", int maxInputSize0InFrames=" + maxInputSizeInFrames + ", int aveRecordsPerFrame=" + aveRecordsPerFrame + ", double fudgeFactor=" + fudgeFactor + ".");
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.HYBRID_HASH_JOIN;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    public double getFudgeFactor() {
        return this.fudgeFactor;
    }

    public int getMemSizeInFrames() {
        return this.memSizeInFrames;
    }

    @Override
    public String toString() {
        return this.getOperatorTag().toString() + " " + this.keysLeftBranch + this.keysRightBranch;
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        int[] keysLeft = JobGenHelper.variablesToFieldIndexes(this.keysLeftBranch, inputSchemas[0]);
        int[] keysRight = JobGenHelper.variablesToFieldIndexes(this.keysRightBranch, inputSchemas[1]);
        IVariableTypeEnvironment env = context.getTypeEnvironment(op);
        IBinaryHashFunctionFactory[] hashFunFactories = JobGenHelper.variablesToBinaryHashFunctionFactories(this.keysLeftBranch, env, context);
        IBinaryHashFunctionFamily[] hashFunFamilies = JobGenHelper.variablesToBinaryHashFunctionFamilies(this.keysLeftBranch, env, context);
        IBinaryComparatorFactory[] comparatorFactories = new IBinaryComparatorFactory[keysLeft.length];
        int i = 0;
        IBinaryComparatorFactoryProvider bcfp = context.getBinaryComparatorFactoryProvider();
        for (LogicalVariable v : this.keysLeftBranch) {
            Object t = env.getVarType(v);
            comparatorFactories[i++] = bcfp.getBinaryComparatorFactory(t, true);
        }
        IPredicateEvaluatorFactoryProvider predEvaluatorFactoryProvider = context.getPredicateEvaluatorFactoryProvider();
        IPredicateEvaluatorFactory predEvaluatorFactory = predEvaluatorFactoryProvider == null ? null : predEvaluatorFactoryProvider.getPredicateEvaluatorFactory(keysLeft, keysRight);
        RecordDescriptor recDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), propagatedSchema, context);
        JobSpecification spec = builder.getJobSpec();
        boolean optimizedHashJoin = true;
        for (IBinaryHashFunctionFamily family : hashFunFamilies) {
            if (family != null) continue;
            optimizedHashJoin = false;
            break;
        }
        IOperatorDescriptor opDesc = optimizedHashJoin ? this.generateOptimizedHashJoinRuntime(context, inputSchemas, keysLeft, keysRight, hashFunFamilies, comparatorFactories, predEvaluatorFactory, recDescriptor, (IOperatorDescriptorRegistry)spec) : this.generateHashJoinRuntime(context, inputSchemas, keysLeft, keysRight, hashFunFactories, comparatorFactories, predEvaluatorFactory, recDescriptor, (IOperatorDescriptorRegistry)spec);
        this.contributeOpDesc(builder, (AbstractLogicalOperator)op, opDesc);
        ILogicalOperator src1 = (ILogicalOperator)op.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src1, 0, op, 0);
        ILogicalOperator src2 = (ILogicalOperator)op.getInputs().get(1).getValue();
        builder.contributeGraphEdge(src2, 0, op, 1);
    }

    private IOperatorDescriptor generateHashJoinRuntime(JobGenContext context, IOperatorSchema[] inputSchemas, int[] keysLeft, int[] keysRight, IBinaryHashFunctionFactory[] hashFunFactories, IBinaryComparatorFactory[] comparatorFactories, IPredicateEvaluatorFactory predEvaluatorFactory, RecordDescriptor recDescriptor, IOperatorDescriptorRegistry spec) throws AlgebricksException {
        HybridHashJoinOperatorDescriptor opDesc;
        try {
            switch (this.kind) {
                case INNER: {
                    opDesc = new HybridHashJoinOperatorDescriptor(spec, this.getMemSizeInFrames(), this.maxInputBuildSizeInFrames, this.aveRecordsPerFrame, this.getFudgeFactor(), keysLeft, keysRight, hashFunFactories, comparatorFactories, recDescriptor, predEvaluatorFactory, false, null);
                    break;
                }
                case LEFT_OUTER: {
                    IMissingWriterFactory[] nonMatchWriterFactories = new IMissingWriterFactory[inputSchemas[1].getSize()];
                    for (int j = 0; j < nonMatchWriterFactories.length; ++j) {
                        nonMatchWriterFactories[j] = context.getMissingWriterFactory();
                    }
                    opDesc = new HybridHashJoinOperatorDescriptor(spec, this.getMemSizeInFrames(), this.maxInputBuildSizeInFrames, this.aveRecordsPerFrame, this.getFudgeFactor(), keysLeft, keysRight, hashFunFactories, comparatorFactories, recDescriptor, predEvaluatorFactory, true, nonMatchWriterFactories);
                    break;
                }
                default: {
                    throw new NotImplementedException();
                }
            }
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return opDesc;
    }

    private IOperatorDescriptor generateOptimizedHashJoinRuntime(JobGenContext context, IOperatorSchema[] inputSchemas, int[] keysLeft, int[] keysRight, IBinaryHashFunctionFamily[] hashFunFamilies, IBinaryComparatorFactory[] comparatorFactories, IPredicateEvaluatorFactory predEvaluatorFactory, RecordDescriptor recDescriptor, IOperatorDescriptorRegistry spec) throws AlgebricksException {
        OptimizedHybridHashJoinOperatorDescriptor opDesc;
        try {
            switch (this.kind) {
                case INNER: {
                    opDesc = new OptimizedHybridHashJoinOperatorDescriptor(spec, this.getMemSizeInFrames(), this.maxInputBuildSizeInFrames, this.getFudgeFactor(), keysLeft, keysRight, hashFunFamilies, comparatorFactories, recDescriptor, (ITuplePairComparatorFactory)new JoinMultiComparatorFactory(comparatorFactories, keysLeft, keysRight), (ITuplePairComparatorFactory)new JoinMultiComparatorFactory(comparatorFactories, keysRight, keysLeft), predEvaluatorFactory);
                    break;
                }
                case LEFT_OUTER: {
                    IMissingWriterFactory[] nonMatchWriterFactories = new IMissingWriterFactory[inputSchemas[1].getSize()];
                    for (int j = 0; j < nonMatchWriterFactories.length; ++j) {
                        nonMatchWriterFactories[j] = context.getMissingWriterFactory();
                    }
                    opDesc = new OptimizedHybridHashJoinOperatorDescriptor(spec, this.getMemSizeInFrames(), this.maxInputBuildSizeInFrames, this.getFudgeFactor(), keysLeft, keysRight, hashFunFamilies, comparatorFactories, recDescriptor, (ITuplePairComparatorFactory)new JoinMultiComparatorFactory(comparatorFactories, keysLeft, keysRight), (ITuplePairComparatorFactory)new JoinMultiComparatorFactory(comparatorFactories, keysRight, keysLeft), predEvaluatorFactory, true, nonMatchWriterFactories);
                    break;
                }
                default: {
                    throw new NotImplementedException();
                }
            }
        }
        catch (HyracksDataException e) {
            throw new AlgebricksException((Throwable)e);
        }
        return opDesc;
    }

    @Override
    protected List<ILocalStructuralProperty> deliveredLocalProperties(ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        ArrayList<ILocalStructuralProperty> deliveredLocalProperties = new ArrayList<ILocalStructuralProperty>();
        if (this.kind != AbstractBinaryJoinOperator.JoinKind.LEFT_OUTER) {
            return deliveredLocalProperties;
        }
        AbstractLogicalOperator probeOp = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        IPhysicalPropertiesVector probeSideProperties = probeOp.getPhysicalOperator().getDeliveredProperties();
        List<ILocalStructuralProperty> probeSideLocalProperties = probeSideProperties.getLocalProperties();
        if (probeSideLocalProperties != null) {
            for (ILocalStructuralProperty property : probeSideLocalProperties) {
                ListSet groupingVars = new ListSet();
                ListSet leftBranchVars = new ListSet();
                property.getVariables((Collection<LogicalVariable>)groupingVars);
                leftBranchVars.addAll(this.getKeysLeftBranch());
                if (!groupingVars.containsAll((Collection<?>)leftBranchVars)) continue;
                deliveredLocalProperties.add(new LocalGroupingProperty((Set<LogicalVariable>)groupingVars));
            }
        }
        return deliveredLocalProperties;
    }
}

