/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.JobSpecification;

public class BulkloadPOperator
extends AbstractPhysicalOperator {
    private final LogicalVariable payload;
    private final List<LogicalVariable> primaryKeys;
    private final List<LogicalVariable> additionalFilteringKeys;
    private final List<LogicalVariable> additionalNonFilterVars;
    private final IDataSource<?> dataSource;

    public BulkloadPOperator(LogicalVariable payload, List<LogicalVariable> keys, List<LogicalVariable> additionalFilteringKeys, List<LogicalVariable> additionalNonFilterVars, IDataSource<?> dataSource) {
        this.payload = payload;
        this.primaryKeys = keys;
        this.additionalFilteringKeys = additionalFilteringKeys;
        this.additionalNonFilterVars = additionalNonFilterVars;
        this.dataSource = dataSource;
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.BULKLOAD;
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        ArrayList<LogicalVariable> scanVariables = new ArrayList<LogicalVariable>();
        scanVariables.addAll(this.primaryKeys);
        scanVariables.add(new LogicalVariable(-1));
        IPhysicalPropertiesVector physicalProps = this.dataSource.getPropertiesProvider().computePropertiesVector(scanVariables);
        StructuralPropertiesVector spv = new StructuralPropertiesVector(physicalProps.getPartitioningProperty(), physicalProps.getLocalProperties());
        return new PhysicalRequirements(new IPhysicalPropertiesVector[]{spv}, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        this.deliveredProperties = op2.getDeliveredPhysicalProperties().clone();
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        InsertDeleteUpsertOperator insertDeleteOp = (InsertDeleteUpsertOperator)op;
        assert (insertDeleteOp.getOperation() == InsertDeleteUpsertOperator.Kind.INSERT);
        assert (insertDeleteOp.isBulkload());
        IMetadataProvider<?, ?> mp = context.getMetadataProvider();
        IVariableTypeEnvironment typeEnv = context.getTypeEnvironment(op);
        JobSpecification spec = builder.getJobSpec();
        RecordDescriptor inputDesc = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment((ILogicalOperator)op.getInputs().get(0).getValue()), inputSchemas[0], context);
        Pair<IOperatorDescriptor, AlgebricksPartitionConstraint> runtimeAndConstraints = mp.getInsertRuntime(this.dataSource, propagatedSchema, typeEnv, this.primaryKeys, this.payload, this.additionalFilteringKeys, this.additionalNonFilterVars, inputDesc, context, spec, true);
        builder.contributeHyracksOperator(insertDeleteOp, (IOperatorDescriptor)runtimeAndConstraints.first);
        builder.contributeAlgebricksPartitionConstraint((IOperatorDescriptor)runtimeAndConstraints.first, (AlgebricksPartitionConstraint)runtimeAndConstraints.second);
        ILogicalOperator src = (ILogicalOperator)insertDeleteOp.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src, 0, insertDeleteOp, 0);
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return false;
    }
}

