/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;

public abstract class AbstractStableSortPOperator
extends AbstractPhysicalOperator {
    protected OrderColumn[] sortColumns;
    protected ILocalStructuralProperty orderProp;

    public OrderColumn[] getSortColumns() {
        return this.sortColumns;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        this.computeLocalProperties(op);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        StructuralPropertiesVector childProp = (StructuralPropertiesVector)op2.getDeliveredPhysicalProperties();
        this.deliveredProperties = new StructuralPropertiesVector(childProp.getPartitioningProperty(), Collections.singletonList(this.orderProp));
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator iop, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        AbstractLogicalOperator op = (AbstractLogicalOperator)iop;
        if (op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED) {
            if (this.orderProp == null) {
                this.computeLocalProperties(op);
            }
            IPhysicalPropertiesVector[] r = new StructuralPropertiesVector[]{new StructuralPropertiesVector(IPartitioningProperty.UNPARTITIONED, Collections.singletonList(this.orderProp))};
            return new PhysicalRequirements(r, IPartitioningRequirementsCoordinator.NO_COORDINATION);
        }
        return this.emptyUnaryRequirements();
    }

    public void computeLocalProperties(ILogicalOperator op) {
        OrderOperator ord = (OrderOperator)op;
        ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> p : ord.getOrderExpressions()) {
            ILogicalExpression expr = (ILogicalExpression)((Mutable)p.second).getValue();
            if (expr.getExpressionTag() == LogicalExpressionTag.VARIABLE) {
                VariableReferenceExpression varRef = (VariableReferenceExpression)expr;
                LogicalVariable var = varRef.getVariableReference();
                orderColumns.add(new OrderColumn(var, ((OrderOperator.IOrder)p.first).getKind()));
                continue;
            }
            throw new IllegalStateException();
        }
        this.sortColumns = orderColumns.toArray(new OrderColumn[orderColumns.size()]);
        this.orderProp = new LocalOrderProperty(orderColumns);
    }

    public ILocalStructuralProperty getOrderProperty() {
        return this.orderProp;
    }

    @Override
    public String toString() {
        if (this.orderProp == null) {
            return this.getOperatorTag().toString();
        }
        return this.getOperatorTag().toString() + " " + this.orderProp;
    }

    @Override
    public Pair<int[], int[]> getInputOutputDependencyLabels(ILogicalOperator op) {
        int[] inputDependencyLabels = new int[]{0};
        int[] outputDependencyLabels = new int[]{1};
        return new Pair((Object)inputDependencyLabels, (Object)outputDependencyLabels);
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return true;
    }
}

