/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class ThreadDumpHelper {
    private ThreadDumpHelper() {
    }

    public static String takeDumpJSON(ThreadMXBean threadMXBean) throws IOException {
        ThreadInfo[] threadInfos = threadMXBean.dumpAllThreads(true, true);
        ArrayList threads = new ArrayList();
        for (ThreadInfo thread : threadInfos) {
            HashMap<String, Object> threadMap = new HashMap<String, Object>();
            threadMap.put("name", thread.getThreadName());
            threadMap.put("id", thread.getThreadId());
            threadMap.put("state", thread.getThreadState().name());
            ArrayList<String> stacktrace = new ArrayList<String>();
            for (StackTraceElement element : thread.getStackTrace()) {
                stacktrace.add(element.toString());
            }
            threadMap.put("stack", stacktrace);
            if (thread.getLockName() != null) {
                threadMap.put("lock_name", thread.getLockName());
            }
            if (thread.getLockOwnerId() != -1L) {
                threadMap.put("lock_owner_id", thread.getLockOwnerId());
            }
            if (thread.getBlockedTime() > 0L) {
                threadMap.put("blocked_time", thread.getBlockedTime());
            }
            if (thread.getBlockedCount() > 0L) {
                threadMap.put("blocked_count", thread.getBlockedCount());
            }
            if (thread.getLockedMonitors().length > 0) {
                threadMap.put("locked_monitors", thread.getLockedMonitors());
            }
            if (thread.getLockedSynchronizers().length > 0) {
                threadMap.put("locked_synchronizers", thread.getLockedSynchronizers());
            }
            threads.add(threadMap);
        }
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("date", new Date().toString());
        json.putPOJO("threads", threads);
        long[] deadlockedThreads = threadMXBean.findDeadlockedThreads();
        long[] monitorDeadlockedThreads = threadMXBean.findMonitorDeadlockedThreads();
        if (deadlockedThreads != null && deadlockedThreads.length > 0) {
            json.putPOJO("deadlocked_thread_ids", (Object)deadlockedThreads);
        }
        if (monitorDeadlockedThreads != null && monitorDeadlockedThreads.length > 0) {
            json.putPOJO("monitor_deadlocked_thread_ids", (Object)monitorDeadlockedThreads);
        }
        om.enable(SerializationFeature.INDENT_OUTPUT);
        return om.writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
    }
}

