/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PidHelper {
    private static final Logger LOGGER = Logger.getLogger(PidHelper.class.getName());

    private PidHelper() {
    }

    public static int getPid() {
        return PidHelper.getPid(ManagementFactory.getRuntimeMXBean());
    }

    public static int getPid(RuntimeMXBean runtimeMXBean) {
        try {
            Field jvmField = runtimeMXBean.getClass().getDeclaredField("jvm");
            jvmField.setAccessible(true);
            Object vmManagement = jvmField.get(runtimeMXBean);
            Method getProcessIdMethod = vmManagement.getClass().getDeclaredMethod("getProcessId", new Class[0]);
            getProcessIdMethod.setAccessible(true);
            return (Integer)getProcessIdMethod.invoke(vmManagement, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Unable to determine PID due to exception", e);
            return -1;
        }
    }
}

