/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.ipc;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.logging.Logger;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.common.base.IClusterController;
import org.apache.hyracks.control.common.controllers.NodeRegistration;
import org.apache.hyracks.control.common.deployment.DeploymentStatus;
import org.apache.hyracks.control.common.heartbeat.HeartbeatData;
import org.apache.hyracks.control.common.ipc.CCNCFunctions;
import org.apache.hyracks.control.common.ipc.ControllerRemoteProxy;
import org.apache.hyracks.control.common.ipc.IControllerRemoteProxyIPCEventListener;
import org.apache.hyracks.control.common.job.PartitionDescriptor;
import org.apache.hyracks.control.common.job.PartitionRequest;
import org.apache.hyracks.control.common.job.profiling.om.JobProfile;
import org.apache.hyracks.control.common.job.profiling.om.TaskProfile;
import org.apache.hyracks.ipc.impl.IPCSystem;

public class ClusterControllerRemoteProxy
extends ControllerRemoteProxy
implements IClusterController {
    private static final Logger LOGGER = Logger.getLogger(ClusterControllerRemoteProxy.class.getName());
    private final int clusterConnectRetries;

    public ClusterControllerRemoteProxy(IPCSystem ipc, InetSocketAddress inetSocketAddress, int clusterConnectRetries, IControllerRemoteProxyIPCEventListener eventListener) {
        super(ipc, inetSocketAddress, eventListener);
        this.clusterConnectRetries = clusterConnectRetries;
    }

    @Override
    protected int getRetries(boolean first) {
        return first ? this.clusterConnectRetries : 0;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public void registerNode(NodeRegistration reg) throws Exception {
        CCNCFunctions.RegisterNodeFunction fn = new CCNCFunctions.RegisterNodeFunction(reg);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void unregisterNode(String nodeId) throws Exception {
        CCNCFunctions.UnregisterNodeFunction fn = new CCNCFunctions.UnregisterNodeFunction(nodeId);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void notifyTaskComplete(JobId jobId, TaskAttemptId taskId, String nodeId, TaskProfile statistics) throws Exception {
        CCNCFunctions.NotifyTaskCompleteFunction fn = new CCNCFunctions.NotifyTaskCompleteFunction(jobId, taskId, nodeId, statistics);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void notifyTaskFailure(JobId jobId, TaskAttemptId taskId, String nodeId, List<Exception> exceptions) throws Exception {
        CCNCFunctions.NotifyTaskFailureFunction fn = new CCNCFunctions.NotifyTaskFailureFunction(jobId, taskId, nodeId, exceptions);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void notifyJobletCleanup(JobId jobId, String nodeId) throws Exception {
        CCNCFunctions.NotifyJobletCleanupFunction fn = new CCNCFunctions.NotifyJobletCleanupFunction(jobId, nodeId);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void notifyDeployBinary(DeploymentId deploymentId, String nodeId, DeploymentStatus status) throws Exception {
        CCNCFunctions.NotifyDeployBinaryFunction fn = new CCNCFunctions.NotifyDeployBinaryFunction(deploymentId, nodeId, status);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void nodeHeartbeat(String id, HeartbeatData hbData) throws Exception {
        CCNCFunctions.NodeHeartbeatFunction fn = new CCNCFunctions.NodeHeartbeatFunction(id, hbData);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void reportProfile(String id, List<JobProfile> profiles) throws Exception {
        CCNCFunctions.ReportProfileFunction fn = new CCNCFunctions.ReportProfileFunction(id, profiles);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void registerPartitionProvider(PartitionDescriptor partitionDescriptor) throws Exception {
        CCNCFunctions.RegisterPartitionProviderFunction fn = new CCNCFunctions.RegisterPartitionProviderFunction(partitionDescriptor);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void registerPartitionRequest(PartitionRequest partitionRequest) throws Exception {
        CCNCFunctions.RegisterPartitionRequestFunction fn = new CCNCFunctions.RegisterPartitionRequestFunction(partitionRequest);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void sendApplicationMessageToCC(byte[] data, DeploymentId deploymentId, String nodeId) throws Exception {
        CCNCFunctions.SendApplicationMessageFunction fn = new CCNCFunctions.SendApplicationMessageFunction(data, deploymentId, nodeId);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void registerResultPartitionLocation(JobId jobId, ResultSetId rsId, boolean orderedResult, boolean emptyResult, int partition, int nPartitions, NetworkAddress networkAddress) throws Exception {
        CCNCFunctions.RegisterResultPartitionLocationFunction fn = new CCNCFunctions.RegisterResultPartitionLocationFunction(jobId, rsId, orderedResult, emptyResult, partition, nPartitions, networkAddress);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void reportResultPartitionWriteCompletion(JobId jobId, ResultSetId rsId, int partition) throws Exception {
        CCNCFunctions.ReportResultPartitionWriteCompletionFunction fn = new CCNCFunctions.ReportResultPartitionWriteCompletionFunction(jobId, rsId, partition);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void notifyDistributedJobFailure(JobId jobId, String nodeId) throws Exception {
        CCNCFunctions.ReportDistributedJobFailureFunction fn = new CCNCFunctions.ReportDistributedJobFailureFunction(jobId, nodeId);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void getNodeControllerInfos() throws Exception {
        this.ensureIpcHandle().send(-1L, (Object)new CCNCFunctions.GetNodeControllersInfoFunction(), null);
    }

    @Override
    public void notifyStateDump(String nodeId, String stateDumpId, String state) throws Exception {
        CCNCFunctions.StateDumpResponseFunction fn = new CCNCFunctions.StateDumpResponseFunction(nodeId, stateDumpId, state);
        this.ensureIpcHandle().send(-1L, (Object)fn, null);
    }

    @Override
    public void notifyShutdown(String nodeId) throws Exception {
        CCNCFunctions.ShutdownResponseFunction sdrf = new CCNCFunctions.ShutdownResponseFunction(nodeId);
        this.ensureIpcHandle().send(-1L, (Object)sdrf, null);
    }

    @Override
    public void notifyThreadDump(String nodeId, String requestId, String threadDumpJSON) throws Exception {
        CCNCFunctions.ThreadDumpResponseFunction tdrf = new CCNCFunctions.ThreadDumpResponseFunction(nodeId, requestId, threadDumpJSON);
        this.ensureIpcHandle().send(-1L, (Object)tdrf, null);
    }
}

